/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.drivers.BridgeToCanOpenHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS24;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS70;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenPlutoGateway;

/**
 * This class is a list of hardware on the LPSC test bench.
 * As the LPSC test bench is the replica of the scale1 prototype and final
 * product, it will be renamed and be used in the scale 1 proto and final product.
 * @author virieux
 */
public class BridgeForLPSCTestBench extends BridgeToCanOpenHardware {

    private final CanOpenEPOS24 hookController;
    private final CanOpenEPOS70 carrierController;
    private final CanOpenPlutoGateway plutoGateway;

    public BridgeForLPSCTestBench(String aName, int aTickMillis,
            CanOpenProxy tcpProxy,
            CanOpenEPOS24 epos24,
            CanOpenEPOS70 epos70,
            CanOpenPlutoGateway plutoGW) {
        super(aName, aTickMillis, tcpProxy);
        this.hookController = epos24;
        this.carrierController = epos70;
        this.plutoGateway = plutoGW;
    }

}
