/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.subsystems.fcs.drivers.BridgeToCanOpenHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS24;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS70;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenPlutoGateway;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;

/**
 * This class represents the list of the hardware on the CPPM testbench.
 * Its goal is to test the hardware we will have on the Scale 1 prototype.
 * It won't be used on the final product neither on the scale 1 prototype.
 * @author virieux
 */
public class BridgeForCPPMTestBench extends BridgeToCanOpenHardware {

    private final CanOpenPlutoGateway plutoGateway;

    private final CanOpenEPOS24 latchController;
    private final CanOpenEPOS70 linearRailMasterController;
    private final CanOpenEPOS70 linearRailSlaveController;
    private final CanOpenEPOS24 onlineClampController;

    /**
     * Build a new BridgeForCPPMTestBench.
     * @param aName
     * @param aTickMillis
     * @param tcpProxy
     * @param plutoGW
     * @param latchController
     * @param linearRailMasterController
     * @param linearRailSlaveController
     * @param onlineClampController 
     */
    public BridgeForCPPMTestBench(String aName, int aTickMillis,
            CanOpenProxy tcpProxy,
            CanOpenPlutoGateway plutoGW,
            CanOpenEPOS24 latchController,
            CanOpenEPOS70 linearRailMasterController,
            CanOpenEPOS70 linearRailSlaveController,
            CanOpenEPOS24 onlineClampController
    ) {
        super(aName, aTickMillis, tcpProxy);
        this.plutoGateway = plutoGW;
        this.latchController = latchController;
        this.linearRailMasterController = linearRailMasterController;
        this.linearRailSlaveController = linearRailSlaveController;
        this.onlineClampController = onlineClampController;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(", plutoGateway=");
        sb.append(String.valueOf(plutoGateway.toString()));
        sb.append(", latchController=");
        sb.append(String.valueOf(latchController.toString()));
        sb.append(", linearRailMasterController=");
        sb.append(String.valueOf(linearRailMasterController.toString()));
        sb.append(", linearRailSlaveController=");
        sb.append(String.valueOf(linearRailSlaveController.toString()));
        sb.append(", onlineClampController=");
        sb.append(String.valueOf(onlineClampController.toString()));
        return sb.toString();
    }

}
