/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.data.Alert;
import static org.lsst.ccs.bus.states.AlertState.ALARM;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.common.Thermometer;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.LoaderDisconnectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

/**
 * Thois soft is to test the FCS with 2 CAN BUS : - one for the carousel and the
 * autochanger - one for the loader
 *
 * @author virieux
 */
public class APCTestBench2CanBusMain extends MainModule {

    /**
     * this bridge is to communicate with the canbus1 on the PC104
     */
    protected BridgeToHardware bridgeToLoader;

    /**
     * * The thermometer mesures the temperature inside the clamp.
     */
    private Thermometer thermometer;
    private CanOpenLED led;
    private CanOpenLED fakeLed;
    private Thermometer fakeSensor;

    public double temperature;

    private boolean ledOn;

    public APCTestBench2CanBusMain(String aName, int aTickMillis, BridgeToHardware bridge, BridgeToHardware bridgeToLoader) {
        super(aName, aTickMillis, bridge);
        this.bridgeToLoader = bridgeToLoader;
    }

    public APCTestBench2CanBusMain(String aName, int aTickMillis,
            BridgeToHardware bridge,
            BridgeToHardware bridgeToLoader,
            Thermometer thermometer,
            CanOpenLED led,
            CanOpenLED fakeLed,
            Thermometer fakeSensor) {
        super(aName, aTickMillis, bridge);
        this.bridgeToLoader = bridgeToLoader;
        this.thermometer = thermometer;
        this.led = led;
        this.fakeLed = fakeLed;
        this.fakeSensor = fakeSensor;
        this.ledOn = false;
    }

    @Command(type = Command.CommandType.QUERY, level = Command.NORMAL,
        description = "Return true if the changer is connected.")    
    public boolean isChangerConnected() {
        return this.bridge.isCWrapperConnected();
    }
    
    @Command(type = Command.CommandType.QUERY, level = Command.NORMAL,
        description = "Return true if the loader is connected.")
    public boolean isLoaderConnected() {
        return this.bridgeToLoader.isCWrapperConnected();
    }

    @Command(type = Command.CommandType.QUERY, level = Command.NORMAL,
        description = "Return true if the hardware of the changer is ready.")     
    public boolean isChangerReady() {
        return this.bridge.isHardwareReady();
    }

    @Command(type = Command.CommandType.QUERY, level = Command.NORMAL,
        description = "Return true if the hardware of the loader is ready.")    
    public boolean isLoaderReady() {
        return this.bridgeToLoader.isHardwareReady();
    }

    @Command(type = Command.CommandType.ACTION, level = Command.NORMAL,
        description = "Disconnect the (fake) loader.")    
    public void disconnectLoader() throws InterruptedException {
        this.bridgeToLoader.getTcpProxy().disconnectHardware();
    }
    
    @Command(type = Command.CommandType.ACTION, level = Command.NORMAL,
            description = "Connect the (fake) loader.")
    public void connectLoader() throws BadCommandException, HardwareException {
        this.bridgeToLoader.getTcpProxy().connectHardware();
    }

    @Command(type = Command.CommandType.QUERY, level = Command.NORMAL,
        description = "Read temperature.")
    public double readTemperature() throws FcsHardwareException, 
            LoaderDisconnectedException {
        try {
            return this.thermometer.readTemperature();
        } catch (FcsHardwareException ex) {
            if (ex instanceof HardwareNotDetectedException) {
                throw new LoaderDisconnectedException(ex.getMessage());
            }
        }
        return 0;
    }

    @Override
    public void tick() {
        try {
            if (ledOn) {
                turnOffLED();
            } else {
                turnOnLED();
            }
        } catch (SDORequestException ex) {
            FCSLOG.error(name + ex);
        } catch (FcsHardwareException ex) {
            FCSLOG.error(name + ex);
            this.getSubsystem().raiseAlert(new Alert(name,ex.toString()), ALARM);
        } 
    }

    /**
     * To turn the LED on.
     * @return
     * @throws SDORequestException
     * @throws HardwareNotDetectedException 
     */
    @Command(type = Command.CommandType.ACTION, level = Command.NORMAL,
            description = "Turn ON the Led.")    
    public String turnOnLED() throws SDORequestException, HardwareNotDetectedException, 
            FcsHardwareException {
        led.turnON();
        ledOn = true;
        return "LED is turned ON";
    }

    @Command(type = Command.CommandType.ACTION, level = Command.NORMAL,
            description = "Turn OFF the Led.")    
    public String turnOffLED() throws SDORequestException, HardwareNotDetectedException, 
            FcsHardwareException {
        led.turnOFF();
        ledOn = false;
        return "LED is turned OFF";
    }

    @Override
    public void updateStateWithSensors() throws FcsHardwareException, 
            ErrorInCommandExecutionException, BadCommandException {
//        try {
//            this.temperature = readTemperature();
//        } catch (LoaderDisconnectedException ex) {
//            throw ex;
//        }
    }

}
