/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.BridgeToCanOpenHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCanOpenProxy;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCompactIOModule;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSControllerModule;

/**
 *
 * @author virieux
 */
public class SimuBridgeToSFTHardware extends BridgeToCanOpenHardware{
    
        
    /*The ADC that we have to control on the Single Filter test bench.*/
    private final PieceOfHardware ai814;

    /*The DAC that we have to control on the Single Filter test bench.*/
    private final PieceOfHardware ao412;

    /*The DAC for the rail sensors that we have to control on the Single Filter test bench.*/
    private final SimuCompactIOModule dio8n1;

    /*The DAC for the filter sensors that we have to control on the Single Filter test bench.*/
    private final SimuCompactIOModule dio8n2;

    /*Controller for clampXminus */
    private final SimuEPOSControllerModule clampXminusController;

    /*Controller for clampXplus.*/
    private final SimuEPOSControllerModule clampXplusController;


    public SimuBridgeToSFTHardware(String aName, int aTickMillis, 
            SimuCanOpenProxy tcpProxy, 
            PieceOfHardware ai814, PieceOfHardware ao412, 
            SimuCompactIOModule dio8n1, SimuCompactIOModule dio8n2, 
            SimuEPOSControllerModule clampXminusController, 
            SimuEPOSControllerModule clampXplusController) {
        super(aName, aTickMillis, tcpProxy);
        this.ai814 = ai814;
        this.ao412 = ao412;
        this.dio8n1 = dio8n1;
        this.dio8n2 = dio8n2;
        this.clampXminusController = clampXminusController;
        this.clampXplusController = clampXplusController;
    }
    
    @Override
    public boolean isRealHardware() {
        return false;
    }

    @Override
    public boolean isCWrapperConnected() {
        return true;
    }

    @Override
    public boolean isHardwareReady() {
        return true;
    }
    
}
