/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByBasicAutoChanger;

/**
 * This class's goal is to create the Objects needed for the GUI and the 
 * Status Bus in the package single-filter-test.
 * @author virieux
 */
public class SftUtils {
    
    /**
     ******************************************************************************
     ** Methods to create Objects to publish data. To be stored in the trending
     * database and update the GUI.
     * *****************************************************************************
     */
        /**
     *
     * @param basicAutoChanger
     * @return
     */
    public static StatusDataPublishedByBasicAutoChanger 
        createStatusDataPublishedByBasicAutoChanger(BasicAutoChangerModule basicAutoChanger) {
        StatusDataPublishedByBasicAutoChanger status = new StatusDataPublishedByBasicAutoChanger();
        status.setName(basicAutoChanger.getName());
        status.setFilterOnTrucksName(basicAutoChanger.getFilterOnTrucksName());
        status.setTrucksEmpty(basicAutoChanger.isTrucksEmpty());
        //status.setTrucksLocation(basicAutoChanger.getLastTrucksLocation());        
        status.setRailSensorStandbackXminusValue(basicAutoChanger.getTruckXminus().getRailSensorStandback().getDigitalValue());
        status.setRailSensorStandbackXplusValue(basicAutoChanger.getTruckXplus().getRailSensorStandback().getDigitalValue());
        status.setRailSensorStandbyXminusValue(basicAutoChanger.getTruckXminus().getRailSensorStandby().getDigitalValue());
        status.setRailSensorStandbyXplusValue(basicAutoChanger.getTruckXplus().getRailSensorStandby().getDigitalValue());
        status.setMovingToStandback(basicAutoChanger.isMovingToStandback());
        status.setMovingToStandby(basicAutoChanger.isMovingToStandby());
        return status;
    }
        
     /**
     * This methods is used in the single-filter-test.
     * @param latch
     * @return 
     */
    public static StatusDataPublishedByAutochangerLatch createStatusDataPublishedByLatch(SftFilterLatchModule latch) {
        StatusDataPublishedByAutochangerLatch status = new StatusDataPublishedByAutochangerLatch();
        status.setName(latch.getName());
        status.setLockSensorValue(latch.getLockSensor().getDigitalValue());
        status.setUnlockSensorValue(latch.getUnlockSensor().getDigitalValue());
        status.setFilterPresenceSensorValue(latch.getFilterPresenceSensor().getDigitalValue());
        status.setLockStatus(latch.getLockStatus());
        status.setControllerInFault(latch.isControllerInFault());
        return status;
    }
    
}
