/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

/**
 * This class is for the Single Filter Test carousel. 
 * The carousel in Single Filter Test has only one socket and doesn't rotate.
 *
 * @author virieux
 */
public class SftCarouselModule extends CarouselModule {

//    public SftCarouselModule(String aName, int aTickMillis, int nbSockets, 
//            List<CarouselSocket> socketsList) {
//        super(aName, aTickMillis, nbSockets, socketsList);
//    }
    

    public SftCarouselModule(String aName, int aTickMillis, 
            CarouselSocket... oneOrMoreSockets) {
        super(aName, aTickMillis, oneOrMoreSockets);
    }

    @Override
    public CarouselSocket getSocketAtStandby() {
        return getSocketByName("socket1");
    }

    @Override
    public double getPosition() {
        return 0;
    }

    /**
     * This method reads the clamps sensors and update the clamps state AND put
     * or remove the filter (software) on the socket at standby. Command to be
     * used in Engineering mode when we execute actions step by step.
     *
     * @throws org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException
     * @throws BadCommandException
     */
    @Command(level = Command.NORMAL, description = "Read clamps sensors, update clamps state "
            + "and sockets field",
            type = Command.CommandType.QUERY, alias = "updState")
    public void updateStateWithSensors() throws FcsHardwareException, BadCommandException {

        if (this.getSocketAtStandby() == null) {
            throw new BadCommandException("Unable to read sensors when there is no socket at standby.");
        }
        this.updateClampsStateWithSensors();

        Filter dummyFilter = ((SftMainModule) this.getComponentByName("main")).getDummyFilter();
        if (this.getSocketAtStandby().isClampedOnFilter()
                || this.getSocketAtStandby().isUnclampedOnFilter()) {
            this.getSocketAtStandby().putFilterOnSocket(dummyFilter);
        } else {
            if (this.getSocketAtStandby().getFilter() != null) {
                //this can happen only in engineering mode when we move the mechanic step by step
                this.getSocketAtStandby().removeFilter();
            }
        }
        publishData();

    }

    @Command(level = Command.NORMAL, description = "Read clamps sensors, update clamps state",
            type = Command.CommandType.QUERY, alias = "updClampsState")
    @Override
    public void updateClampsStateWithSensors() throws BadCommandException, FcsHardwareException {
        updateClampsStateWithSensorsFromPDO();
    }

    @Override
    public boolean isAbleToMove() {
        return false;
    }

    @Override
    public boolean isRotating() {
        return false;
    }

    /**
     * Carousel can't rotate in single-filter-test
     * @param angle
     * @return 
     */
    @Override
    public String rotate(double angle) {
        throw new UnsupportedOperationException("Operation rotate not available in Single Filter Test");
    }

    /**
     * No brake in single-filter-test carousel.
     * @return 
     */
    @Override
    public String engageBrake() {
        throw new UnsupportedOperationException("Operation not available in Single Filter Test");
    }

    /**
     * No brake in single-filter-test carousel.
     * @return 
     */
    @Override
    public String releaseBrake() {
        throw new UnsupportedOperationException("Operation not available in Single Filter Test");
    }

}
