/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import org.lsst.ccs.subsystems.fcs.drivers.BridgeToCanOpenHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenADC;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDAC;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenEPOS24;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;

/**
 * This class is to list the hardware we have to control in the
 * single-filter-test
 *
 * @author virieux
 */
public class BridgeToSFTHardware extends BridgeToCanOpenHardware {
    
    
    /*The ADC that we have to control on the Single Filter test bench.*/
    private final CanOpenADC ai814;

    /*The DAC that we have to control on the Single Filter test bench.*/
    private final CanOpenDAC ao412;

    /*The DAC that we have to control on the Single Filter test bench.*/
    private final CompactIOModule dio8n1;

    /*The DAC that we have to control on the Single Filter test bench.*/
    private final CompactIOModule dio8n2;

    /*Controller for clampXminus */
    private final CanOpenEPOS24 clampXminusController;

    /*Controller for clampXplus.*/
    private final CanOpenEPOS24 clampXplusController;

    public BridgeToSFTHardware(String aName, int aTickMillis, CanOpenProxy tcpProxy,
            CanOpenADC ai814,
            CanOpenDAC ao412,
            CompactIOModule dio8n1,
            CompactIOModule dio8n2,
            CanOpenEPOS24 clampXminusCtl,
            CanOpenEPOS24 clampXplusCtl) {
        super(aName, aTickMillis, tcpProxy);

        this.ai814 = ai814;
        this.ao412 = ao412;
        this.dio8n1 = dio8n1;
        this.dio8n2 = dio8n2;
        this.clampXminusController = clampXminusCtl;
        this.clampXplusController = clampXplusCtl;
    }


}
