/*
 * To change this template, choose Tools | Templates
 * and on the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.subsystems.fcs.errors.CanOpenException;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftTruckMotor;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;

/**
 * To simulate a motor which moves a truck in the autochanger.
 *
 * @author virieux
 */
public class SimuTruckMotorModule extends SftTruckMotor {


    private SftAutoChangerModule autochanger;
    private SimuCarouselClamp clampXminus;
    private SimuCarouselClamp clampXplus;

    public SimuTruckMotorModule(String name, int tickMillis) {
        super(name, tickMillis);
    }
    
    

    @Override
    public void initModule() {
        this.autochanger = (SftAutoChangerModule) this.getComponentByName("autochanger");
        this.clampXminus = (SimuCarouselClamp) this.getComponentByName("clampXminus");
        this.clampXplus = (SimuCarouselClamp) this.getComponentByName("clampXplus");

    }

    @Override
    public String moveToStandback() throws CanOpenException {

        if (autochanger.isAtStandby()) {

            this.setMovingToStandback(true);
            long timeToGo = autochanger.getTimeToGoToStandback()/10;
            try {
                FCSLOG.debug(getName() + ": Waiting for the motor to go to STANDBACK");
                Thread.sleep(timeToGo);
            } catch (InterruptedException ex) {
                FCSLOG.debug(ex);
            }

            this.setMovingToStandback(false);

            // The simulated rails sensors have to say that the trucks are in standback.
            SimuCompactIOModule simuRailsSensors = (SimuCompactIOModule) autochanger.getRailsSensorsDIO();
            simuRailsSensors.setHexaValue("50");

            //The simulated filter sensors have to say if the filter is in the latches or not.
            SimuCompactIOModule simuFilterSensors = (SimuCompactIOModule) autochanger.getFilterSensorsDIO();
            if (autochanger.isTrucksEmpty()) {
                //if the trucks are empty, the filter is at standby on  carousel, so when the trucks are in
                //standback position, the latches filter presence sensor have to return the value "0".
                simuFilterSensors.simulateFilterPresenceInLatches("0");

            } else {
                //if the trucks are loaded and going to standback, at the end of the simulated motion, 
                //the clamp filter presence sensors should "see" that there NO_FILTER anymore.
                ((SimuClampFilterPresenceSensor) this.clampXminus.getFilterPresenceSensor()).simulateNoFilter(clampXminus);
                ((SimuClampFilterPresenceSensor) this.clampXplus.getFilterPresenceSensor()).simulateNoFilter(clampXplus);
                FCSLOG.debug("====> END OF moveToStandback");
            }
        }

        return "Trucks are At Standback.";

    }

    /**
     * The method moveToStandby for the simulated trucks motor updates the rails
     * sensors and the filter presence sensor in the latches.
     *
     * @return
     * @throws org.lsst.ccs.subsystems.fcs.errors.CanOpenException
     */
    @Override
    public String moveToStandby() throws CanOpenException {

        if (autochanger.isAtStandback()) {

            this.setMovingToStandby(true);
            long timeToGo = autochanger.getTimeToGoToStandby();
            try {
                FCSLOG.debug(getName() + ": Waiting for the motor to go to STANDBY");
                Thread.sleep(timeToGo);
            } catch (InterruptedException ex) {
                FCSLOG.debug(ex);
            }

            this.setMovingToStandby(false);

            SimuCompactIOModule simuRailsSensor = (SimuCompactIOModule) autochanger.getRailsSensorsDIO();
            //TODO SimuCompactIOModule should provide a more generic method to simulate the rails sensors.
            simuRailsSensor.setHexaValue("A0");

            //The simulated filter sensors have to say if the filter is in the latches or not.
            SimuCompactIOModule simuFilterSensors = (SimuCompactIOModule) autochanger.getFilterSensorsDIO();

            //The simulated filter sensors have to say if the filter is in the latches or not.
            if (autochanger.isTrucksEmpty()) {
                //if the trucks are empty, the filter is at standby on  carousel, so at the end of the 
                //moveToStandby command, the latches filter presence sensor have to return the value "1".
                simuFilterSensors.simulateFilterPresenceInLatches("1");
            } else {

                //if the trucks are loaded and going to standby, at the end of the simulated motion, 
                //the clamps filter presence sensors should "see" that the filter is LOCKABLE.
                //and the lock sensor should see that the clamps are LOCKED.
                ((SimuClampFilterPresenceSensor) this.clampXminus.getFilterPresenceSensor()).simulateFilterIsLockable(clampXminus);
                ((SimuClampFilterPresenceSensor) this.clampXplus.getFilterPresenceSensor()).simulateFilterIsLockable(clampXplus);
                ((SimuClampLockSensor) this.clampXminus.getLockSensor()).simulateClampIsLOCKED(clampXminus);
                ((SimuClampLockSensor) this.clampXplus.getLockSensor()).simulateClampIsLOCKED(clampXplus);
            }
        }
        return "Trucks are At Standby.";
    }

    @Override
    public String off() throws CanOpenException {
        this.setMovingToStandback(false);
        this.setMovingToStandby(false);
        return "Trucks motor is OFF";
    }

}
