/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftCarouselModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftMainModule;

/**
 *
 * @author virieux
 */
public class SimuSftCarouselModule extends SftCarouselModule {
    

    public SimuSftCarouselModule(String aName, int aTickMillis, 
            CarouselSocket... oneOrMoreSockets) {
        super(aName, aTickMillis, oneOrMoreSockets);
    }

    @Override
    public void updateStateWithSensors() throws BadCommandException, FcsHardwareException {
        if (this.getSocketAtStandby() == null) {
            throw new BadCommandException("Unable to read sensors when there is no socket at standby.");
        }
        this.getSocketAtStandby().updateClampsStateWithSensorsFromSDO();

        Filter dummyFilter = ((SftMainModule) this.getComponentByName("main")).getDummyFilter();
        if (this.getSocketAtStandby().isClampedOnFilter()
                || this.getSocketAtStandby().isUnclampedOnFilter()) {
            this.getSocketAtStandby().putFilterOnSocket(dummyFilter);
        } else {
            if (!(this.getSocketAtStandby().getFilter() == null)) {
                //this can happen only in engineering mode when we move the mechanic step by step
                this.getSocketAtStandby().removeFilter();
            }
        }
    }

    @Override
    public void updateClampsStateWithSensors() throws BadCommandException, FcsHardwareException {
        updateClampsStateWithSensorsFromSDO();
    }

}
