/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.LoaderModule;

/**
 *
 * @author virieux
 */
public class SimuLoaderPlutoGateway extends SimuPlutoGateway {

    private LoaderModule loader;
    private SimuLoaderCarrierController carrierController;
    private SimuPlutoGWSensor lockSensor1;
    private SimuPlutoGWSensor unlockSensor1;
    private SimuPlutoGWSensor lockSensor2;
    private SimuPlutoGWSensor unlockSensor2;
    private SimuPlutoGWSensor lockSensor3;
    private SimuPlutoGWSensor unlockSensor3;
    private SimuPlutoGWSensor lockSensor4;
    private SimuPlutoGWSensor unlockSensor4;
    private SimuPlutoGWSensor loaderOnCameraSensor0;
    private SimuPlutoGWSensor loaderOnCameraSensor1;
    private SimuPlutoGWSensor filterPresenceSensor0;
    private SimuPlutoGWSensor filterPresenceSensor1;
    private SimuPlutoGWSensor autochangerHoldingFilterSensor;
    private SimuPlutoGWSensor storagePositionSensor0;
    private SimuPlutoGWSensor handoffPositionSensor0;
    private SimuPlutoGWSensor storagePositionSensor1;
    private SimuPlutoGWSensor handoffPositionSensor1;

    public SimuLoaderPlutoGateway(String name, int tickMillis, String nodeID, String serialNB) {
        super(name, tickMillis, nodeID, serialNB);
    }

    @Override
    public void initModule() {
        super.initModule();
        this.hexaValues[0] = "00";
        this.hexaValues[1] = "00";
        this.hexaValues[2] = "00";
        this.hexaValues[3] = "00";
        this.hexaValues[4] = "00";
        this.hexaValues[5] = "00";
        this.lockSensor1 = (SimuPlutoGWSensor) getComponentByName("lockSensor1");
        this.lockSensor2 = (SimuPlutoGWSensor) getComponentByName("lockSensor2");
        this.lockSensor3 = (SimuPlutoGWSensor) getComponentByName("lockSensor3");
        this.lockSensor4 = (SimuPlutoGWSensor) getComponentByName("lockSensor4");
        this.unlockSensor1 = (SimuPlutoGWSensor) getComponentByName("unlockSensor1");
        this.unlockSensor2 = (SimuPlutoGWSensor) getComponentByName("unlockSensor2");
        this.unlockSensor3 = (SimuPlutoGWSensor) getComponentByName("unlockSensor3");
        this.unlockSensor4 = (SimuPlutoGWSensor) getComponentByName("unlockSensor4");
        this.loaderOnCameraSensor0 = (SimuPlutoGWSensor) getComponentByName("loaderOnCameraSensor0");
        this.loaderOnCameraSensor1 = (SimuPlutoGWSensor) getComponentByName("loaderOnCameraSensor1");
        this.filterPresenceSensor0 = (SimuPlutoGWSensor) getComponentByName("filterPresenceSensor0");
        this.filterPresenceSensor1 = (SimuPlutoGWSensor) getComponentByName("filterPresenceSensor1");
        this.autochangerHoldingFilterSensor = (SimuPlutoGWSensor) getComponentByName("autochangerHoldingFilterSensor");
        this.storagePositionSensor0 = (SimuPlutoGWSensor) getComponentByName("storagePositionSensor0");
        this.storagePositionSensor1 = (SimuPlutoGWSensor) getComponentByName("storagePositionSensor1");
        this.handoffPositionSensor0 = (SimuPlutoGWSensor) getComponentByName("handoffPositionSensor0");
        this.handoffPositionSensor1 = (SimuPlutoGWSensor) getComponentByName("handoffPositionSensor1");
        this.carrierController = (SimuLoaderCarrierController) this.getComponentByName("carrierController");
        this.loader = (LoaderModule) this.getComponentByName("loader");
        //Filter is locked and carrier is at storage position
        simulateLoaderClampIsLocked();
        simulateLoaderIsConnectedOnCamera();
        simulateAutochangerIsNotHoldingFilter();
        simulateFilterIsOnLoader();
        simulateLoaderCarrierIsAtStorage();
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderClampIsLocked() {
        simulateHookIsLocked(lockSensor1, unlockSensor1);
        simulateHookIsLocked(lockSensor2, unlockSensor2);
        simulateHookIsLocked(lockSensor3, unlockSensor3);
        simulateHookIsLocked(lockSensor4, unlockSensor4);
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderClampIsUnLocked() {
        simulateHookIsUnlocked(lockSensor1, unlockSensor1);
        simulateHookIsUnlocked(lockSensor2, unlockSensor2);
        simulateHookIsUnlocked(lockSensor3, unlockSensor3);
        simulateHookIsUnlocked(lockSensor4, unlockSensor4);
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderClampIsInTravel() {
        simulateHookIsInTravel(lockSensor1, unlockSensor1);
        simulateHookIsInTravel(lockSensor2, unlockSensor2);
        simulateHookIsInTravel(lockSensor3, unlockSensor3);
        simulateHookIsInTravel(lockSensor4, unlockSensor4);
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateHookIsLocked(SimuPlutoGWSensor lockSensor, SimuPlutoGWSensor unlockSensor) {
        replaceDigitalValues(lockSensor, "1");
        replaceDigitalValues(unlockSensor, "0");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateHookIsUnlocked(SimuPlutoGWSensor lockSensor, SimuPlutoGWSensor unlockSensor) {
        replaceDigitalValues(lockSensor, "0");
        replaceDigitalValues(unlockSensor, "1");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateHookIsInTravel(SimuPlutoGWSensor lockSensor, SimuPlutoGWSensor unlockSensor) {
        replaceDigitalValues(lockSensor, "0");
        replaceDigitalValues(unlockSensor, "0");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderIsConnectedOnCamera() {
        replaceDigitalValues(loaderOnCameraSensor0, "1");
        replaceDigitalValues(loaderOnCameraSensor1, "1");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderIsNotConnectedOnCamera() {
        replaceDigitalValues(loaderOnCameraSensor0, "0");
        replaceDigitalValues(loaderOnCameraSensor1, "0");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateFilterIsOnLoader() {
        replaceDigitalValues(filterPresenceSensor0, "1");
        replaceDigitalValues(filterPresenceSensor1, "1");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateFilterIsNotOnLoader() {
        replaceDigitalValues(filterPresenceSensor0, "0");
        replaceDigitalValues(filterPresenceSensor1, "0");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerIsHoldingFilter() {
        replaceDigitalValues(autochangerHoldingFilterSensor, "1");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerIsNotHoldingFilter() {
        replaceDigitalValues(autochangerHoldingFilterSensor, "0");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderCarrierIsAtStorage() {
        replaceDigitalValues(storagePositionSensor0, "1");
        replaceDigitalValues(storagePositionSensor1, "1");
        replaceDigitalValues(handoffPositionSensor0, "0");
        replaceDigitalValues(handoffPositionSensor1, "0");
        carrierController.setPosition(loader.getCarrier().getStoragePosition());
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderCarrierIsAtHandoff() {
        replaceDigitalValues(storagePositionSensor0, "0");
        replaceDigitalValues(storagePositionSensor1, "0");
        replaceDigitalValues(handoffPositionSensor0, "1");
        replaceDigitalValues(handoffPositionSensor1, "1");
        carrierController.setPosition(loader.getCarrier().getHandoffPosition());
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderCarrierIsInTravel() {
        replaceDigitalValues(storagePositionSensor0, "0");
        replaceDigitalValues(storagePositionSensor1, "0");
        replaceDigitalValues(handoffPositionSensor0, "0");
        replaceDigitalValues(handoffPositionSensor1, "0");
    }

}
