/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.messaging.BadCommandException;

import org.lsst.ccs.subsystems.fcs.LoaderCarrierModule;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;

/**
 *
 * @author virieux
 */
public class SimuLoaderCarrierController extends SimuEPOSControllerModule {

    private LoaderCarrierModule carrier;
    private SimuLoaderPlutoGateway plutoGateway;

    public SimuLoaderCarrierController(String aName, int aTickMillis,
            String nodeID, String serialNB,
            Map<String, Integer> paramsForCurrent,
            Map<String, Integer> paramsForProfilePosition,
            Map<String, Integer> paramsForHoming
    ) {
        super(aName, aTickMillis, nodeID, serialNB, paramsForCurrent, paramsForProfilePosition, paramsForHoming);

    }

    @Override
    public void initModule() {
        super.initModule();
        carrier = (LoaderCarrierModule) this.getComponentByName("carrier");
        plutoGateway = (SimuLoaderPlutoGateway) this.getComponentByName("plutoGateway");
    }

    @Override
    public void writeTargetPosition(int positionToReached)
            throws BadCommandException, SDORequestException {
        this.targetPosition = positionToReached;
        int positionInitiale = this.position;
        FCSLOG.debug("loader carrier is moving.");
        FCSLOG.debug(name + "=>position intitiale=" + position);
        int stepsNB = 20;
        int step = (targetPosition - this.position) / stepsNB;

        for (int i = 1; i < stepsNB; i++) {
            try {

                this.position = positionInitiale + (i * step);
                carrier.updatePosition();
                if (position == carrier.getHandoffPosition()) {
                    FCSLOG.debug("plutoGateway=" + plutoGateway.toString());
                    this.plutoGateway.simulateLoaderCarrierIsAtHandoff();
                } else if (position == carrier.getStoragePosition()) {
                    this.plutoGateway.simulateLoaderCarrierIsAtStorage();
                } else {
                    this.plutoGateway.simulateLoaderCarrierIsInTravel();
                }
                carrier.updateStateWithSensors();
                carrier.publishData();
                FCSLOG.debug(name + "i=" + i + ",position=" + position);
                try {
                    Thread.sleep(500);
                    if (carrier.getHaltRequired().get()) {
                        FCSLOG.debug(name + " STOP simulated carrrier motion.");
                        return;
                    }
                } catch (InterruptedException ex) {
                    throw new BadCommandException(name + " sleep was interrupted.");
                }

            } catch (FcsHardwareException ex) {
                FCSLOG.error(ex);
                throw new BadCommandException(ex.getMessage());
            }

        }
        this.position = targetPosition;
        if (position == carrier.getHandoffPosition()) {
            FCSLOG.debug("plutoGateway=" + plutoGateway.toString());
            this.plutoGateway.simulateLoaderCarrierIsAtHandoff();
        } else if (position == carrier.getStoragePosition()) {
            this.plutoGateway.simulateLoaderCarrierIsAtStorage();
        } else {
            this.plutoGateway.simulateLoaderCarrierIsInTravel();
        }

    }

}
