/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.CompactIOModule;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

/**
 *
 * @author virieux
 */
public class SimuCompactIOModule extends CompactIOModule {

    private String initialHexaValue;
    private SimuNumericSensor filterPresenceSensorLatchXminus;
    private SimuNumericSensor filterPresenceSensorLatchXplus;

    public SimuCompactIOModule( String aName, 
            int aTickMillis, 
            String nodeID, 
            String serialNB,
            String initialHexaValue) {
        super(aName, aTickMillis, nodeID, serialNB);
        this.initialHexaValue = initialHexaValue;
    }
    
    

    public String getInitialHexaValue() {
        return initialHexaValue;
    }

    public void setInitialHexaValue(String initialHexaValue) {
        this.initialHexaValue = initialHexaValue;
    }

    public void setHexaValue(String hex) {
        this.hexaValue = hex;
    }

    @Override
    public void initModule() {

        this.hexaValue = this.initialHexaValue;
        this.filterPresenceSensorLatchXminus = (SimuNumericSensor) this.getComponentByName("filterPresenceSensorLatchXminus");
        this.filterPresenceSensorLatchXplus = (SimuNumericSensor) this.getComponentByName("filterPresenceSensorLatchXplus");

    }

    @Override
    public String readNewHexaValue() {
        return this.hexaValue;
    }
    

    /**
     * This method updates the 2 filter presence simulated digital sensors (one
     * on each side of the filter).
     *
     * @param aDigitalValue has to be "0" or "1"
     */
    public void simulateFilterPresenceInLatches(String aDigitalValue) {

        int inputNumeroXminus = this.filterPresenceSensorLatchXminus.getInputNumero();
        int inputNumeroXplus = this.filterPresenceSensorLatchXplus.getInputNumero();

        this.replaceDigitalValues(inputNumeroXminus, aDigitalValue, inputNumeroXplus, aDigitalValue);
    }

    /**
     * This method replace the values of 2 channels in hexaValue with the
     * digital values given as argument. The value for channel1 is replaced by
     * digitalValue1. The value for channel2 is replaced by digitalValue2. This
     * is useful when we want to simulate a new value sent by the sensors.
     * @param channel1
     * @param digitalValue1
     * @param channel2
     * @param digitalValue2
     */
    public void replaceDigitalValues(int channel1, String digitalValue1, int channel2, String digitalValue2) {
        if (channel1 < 1 || channel1 > 8) {
            throw new IllegalArgumentException("bad value for channel1 : Channel numero has to be between 1 and 8.");
        }
        if (channel2 < 1 || channel2 > 8) {
            throw new IllegalArgumentException("bad value for channel2 : Channel numero has to be between 1 and 8.");
        }
        if (!digitalValue1.equals("0") && !digitalValue1.equals("1")) {
            throw new IllegalArgumentException("digitalValue1 has to be a String equals \"0\" or \"1\". ");
        }
        if (!digitalValue2.equals("0") && !digitalValue2.equals("1")) {
            throw new IllegalArgumentException("digitalValue1 has to be a String equals \"0\" or \"1\". ");
        }

        FCSLOG.debug(getName() + "=> old hexa value = " + this.hexaValue);
        StringBuilder bin = new StringBuilder(FcsUtils.hexToBinary(this.hexaValue));
        bin.replace(8 - channel1, 8 - channel1 + 1, digitalValue1);
        bin.replace(8 - channel2, 8 - channel2 + 1, digitalValue2);
        String newDIOHexaValue = Integer.toHexString(Integer.parseInt(bin.toString(), 2));
        FCSLOG.debug(getName() + "=> new hexa value =" + newDIOHexaValue);
        this.hexaValue = newDIOHexaValue;
    }

}
