/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

/**
 * This is used to simulated the single-filter-test clamp lock sensor.
 * It has to be replaced by a class SimuCarouselClampLockSensorController.
 * @author virieux
 */
public class SimuClampLockSensor extends SimuSensor14bits {

    /**
     * Create a new SimuClampLockSensor.
     * @param moduleName
     * @param aTickMillis 
     */
    public SimuClampLockSensor(String moduleName, int aTickMillis) {
        super(moduleName, aTickMillis, 29000);
    }

    /**
     * Simulate that the clamp is locked.
     * @param clamp 
     */
    public void simulateClampIsLOCKED(SimuCarouselClamp clamp) {
        this.setNewRange(clamp.getLockSensorValueB(), clamp.getLockSensorValueC());
    }

    /**
     * Simulate that the clamp is unlocked.
     * @param clamp 
     */
    public void simulateClampIsUNLOCKED(SimuCarouselClamp clamp) {
        this.setNewRange(clamp.getLockSensorMinValue(), clamp.getLockSensorValueA());
    }

}
