/*
 * To change this template, choose Tools | Templates
 * and on the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterClampState;
import org.lsst.ccs.subsystems.fcs.common.Sensor14bits;
import org.lsst.ccs.subsystems.fcs.common.Thermometer;

/**
 *
 * @author virieux
 */
public class SimuCarouselClampXminus extends SimuCarouselClamp {

    public SimuCarouselClampXminus(String aName, int aTickMillis, 
            //String controllerName, 
            Sensor14bits filterPresenceSensor, Sensor14bits lockSensor, Thermometer thermometer, 
            int filterPositionValueA, int filterPositionValueB, int filterPositionValueC, 
            int filterPositionOffset, int lockSensorValueA, int lockSensorValueB, int lockSensorValueC, 
            int lockSensorOffset, int timeoutForUnlocking, int timeoutForReleasing, 
            int currentToUnlock, int currentToMaintainUnlocked) {
        super(aName, aTickMillis, 
                //controllerName, 
                filterPresenceSensor, lockSensor, thermometer, 
                filterPositionValueA, filterPositionValueB, filterPositionValueC, filterPositionOffset, 
                lockSensorValueA, lockSensorValueB, lockSensorValueC, lockSensorOffset, 
                timeoutForUnlocking, timeoutForReleasing, currentToUnlock, currentToMaintainUnlocked);
    }


    

    @Override
    public FilterClampState computeClampState() {

        FilterClampState state = super.computeClampState();
        if (state.equals(FilterClampState.UNCLAMPEDEMPTY) 
                && this.controller.isTurnedOff()) {
            return FilterClampState.READYTOCLAMP;
        } else {
            return state;
        }
    }

}
