/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations.EposMode;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

/**
 * To simulate a controller which can open carousel clamps.
 * @author virieux
 */
public class SimuCarouselClampController extends SimuEPOSControllerModule {

    private CarouselModule carousel;
    
    public SimuCarouselClampController(String aName, int aTickMillis, 
            String nodeID, String serialNB, 
            Map<String, Integer> paramsForCurrent, 
            Map<String, Integer> paramsForProfilePosition, 
            Map<String, Integer> paramsForHoming) {
        super(aName, aTickMillis, nodeID, serialNB, 
                paramsForCurrent, paramsForProfilePosition, paramsForHoming);
    }
    
    @Override
    public void initModule() {
        super.initModule();
        this.carousel = (CarouselModule) this.getComponentByName("carousel");
        this.mode = EposMode.CURRENT;
    }
    

    @Override
    public void writeCurrent(int currentValue) throws BadCommandException, SDORequestException {

        FCSLOG.debug(getName() + "==========> ACTUATOR ON");

        //the clamp is now UNLOCKED : we have to simulate that.
        SimuCarouselClamp clamp;
        if (name.contains("Xminus")) {
            clamp = (SimuCarouselClamp) this.carousel.getClampXminus();
        } else if (name.contains("Xplus")) {
            clamp = (SimuCarouselClamp) this.carousel.getClampXplus();
        } else {
            throw new BadCommandException(name + ":couldn't find the clamp to unlock");
        }
        ((SimuClampLockSensor) clamp.getLockSensor()).simulateClampIsUNLOCKED(clamp);

        //we have to publish on status bus the sentValue (for the GUI)
        //not done in CanOPenEPOS
        this.publishData();
    }

    @Override
    public String off() throws BadCommandException, ErrorInCommandExecutionException {
        FCSLOG.debug(getName() + "==========> ACTUATOR OFF");
        //the clamp is now LOCKED : we have to simulate that.
        SimuCarouselClamp clamp;
        if (getName().contains("Xminus")) {
            clamp = (SimuCarouselClamp) this.carousel.getClampXminus();
        } else if (getName().contains("Xplus")) {
            clamp = (SimuCarouselClamp) this.carousel.getClampXplus();
        } else {
            throw new ErrorInCommandExecutionException(getName() + ": unable to find the clamp to unlock.");
        }
        ((SimuClampLockSensor) clamp.getLockSensor()).simulateClampIsLOCKED(clamp);
        turnedOff = true;
        this.publishData();
        return getName() + " is turned OFF.";
    }    
    
}
