/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.BasicAutoChangerModule;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterPresenceStatus;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.CarouselClampModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterClampState;
import org.lsst.ccs.subsystems.fcs.common.Sensor14bits;
import org.lsst.ccs.subsystems.fcs.common.Thermometer;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;

/**
 * A very basic simulated filter clamp module. It has no sensor to know if the
 clamp is locked or not. This clamp is locked when the clamps controller of the
 carousel are off. And its filter presence sensor is configured to returns the
 value we expect!
 *
 * @author virieux
 */
public class SimuCarouselClamp extends CarouselClampModule {

    protected CarouselModule carousel;
    protected Filter dummyFilter;
    //TODO just for tests (cf tick method). 
    private BasicAutoChangerModule autochanger;

    public SimuCarouselClamp(String aName, int aTickMillis, 
            //String controllerName, 
            Sensor14bits filterPresenceSensor, Sensor14bits lockSensor, Thermometer thermometer, 
            int filterPositionValueA, int filterPositionValueB, int filterPositionValueC, 
            int filterPositionOffset, int lockSensorValueA, int lockSensorValueB, int lockSensorValueC, 
            int lockSensorOffset, int timeoutForUnlocking, int timeoutForReleasing, 
            int currentToUnlock, int currentToMaintainUnlocked) {
        super(aName, aTickMillis, //controllerName, 
                filterPresenceSensor, lockSensor, 
                thermometer, filterPositionValueA, filterPositionValueB, filterPositionValueC, 
                filterPositionOffset, lockSensorValueA, lockSensorValueB, lockSensorValueC, 
                lockSensorOffset, timeoutForUnlocking, timeoutForReleasing, 
                currentToUnlock, currentToMaintainUnlocked);
    }



    //FOR SPRING
    public Filter getDummyFilter() {
        return dummyFilter;
    }

    //FOR SPRING
    public void setDummyFilter(Filter dummyFilter) {
        this.dummyFilter = dummyFilter;
    }

    @Override
    public double updateTemperature() {
        throw new UnsupportedOperationException(getName() + "updateTYemperature : Not supported yet.");
    }

    @Override
    public void initModule() {
        super.initModule();
        this.carousel = (CarouselModule) this.getComponentByName("carousel");
        this.autochanger = (BasicAutoChangerModule) this.getComponentByName("autochanger");

        this.filterPresenceStatus = FilterPresenceStatus.LOCKABLE;

        this.clampState = FilterClampState.CLAMPEDONFILTER;
        ((SimuClampFilterPresenceSensor) getFilterPresenceSensor()).simulateFilterIsLockable(this);
        ((SimuClampLockSensor) getLockSensor()).simulateClampIsLOCKED(this);
        this.setLockStatus(LockStatus.LOCKED);
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) throws SDORequestException, BadCommandException,
            ErrorInCommandExecutionException, FcsHardwareException {
        if (action.equals(FcsEnumerations.MobileItemAction.UNLOCK)) {
        } else if (action.equals(FcsEnumerations.MobileItemAction.RELEASE)) {
            this.controller.off();
        } else {
            throw new IllegalArgumentException("Action on clamp must be UNLOCK or RELEASE");
        }

    }

    @Override
    public void updateStateWithSensors() throws FcsHardwareException {
        updateStateWithSensorsFromSDO();
    }

}
