/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;

/**
 *
 * @author virieux
 */
public class SimuCanOpenProxy extends CanOpenProxy {

    public SimuCanOpenProxy(String aName, int aTickMillis,
            int portNumber, String aClientName,
            long hardwareBootTimeout) {
        super(aName, aTickMillis, portNumber, aClientName, hardwareBootTimeout);
    }
    
    

    @Override
    public void initModule() {
        super.initModule();
    }

    @Override
    public void startServer() {
        tcpServerStarted = true;
        stopped = false;
    }

    @Override
    public void startThreadReader() {
    }

    @Override
    public void stopServer() {
        stopped = true;
        tcpServerStarted = false;
    }

    @Override
    public TreeWalkerDiag checkHardware() throws org.lsst.ccs.HardwareException {
        //for the GUI
        for (PieceOfHardware device : hardwareList) {
            device.setBooted(true);
            publishHardwareData(device);
        }
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

}
