/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.drivers.BridgeToCanOpenHardware;
import org.lsst.ccs.subsystems.fcs.common.PDOStorage;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;

/**
 *
 * @author virieux
 */
public class SimuBridgeForLPSCTestBench extends BridgeToCanOpenHardware {

    private final SimuEPOSControllerModule hooksController;
    private final SimuEPOSControllerModule carrierController;
    private final SimuPlutoGateway plutoGateway;

    public SimuBridgeForLPSCTestBench(String name, int aTickMillis,
            SimuCanOpenProxy tcpProxy,
            SimuEPOSControllerModule hooksController,
            SimuEPOSControllerModule carrierController,
            SimuPlutoGateway plutoGateway) {
        super(name, aTickMillis, tcpProxy);
        this.hooksController = hooksController;
        this.carrierController = carrierController;
        this.plutoGateway = plutoGateway;
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1, description = "print my children; for tests")
    public void printChildren() {
        Map<String, SimuEPOSControllerModule> children = this.getChildren(org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSControllerModule.class);
        for (Map.Entry<String, SimuEPOSControllerModule> entry : children.entrySet()) {
            String key = entry.getKey();
            FCSLOG.debug("key=" + key);
            SimuEPOSControllerModule epos = entry.getValue();
            FCSLOG.debug("epos=" + epos.getName() + "#" + epos.toString());

        }
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1, description = "print my children; for tests")
    public void printChildren2() {
        Map<String, EPOSController> children = this.getChildren(org.lsst.ccs.subsystems.fcs.common.EPOSController.class);
        for (Map.Entry<String, EPOSController> entry : children.entrySet()) {
            String key = entry.getKey();
            FCSLOG.debug("key=" + key);
            EPOSController epos = entry.getValue();
            FCSLOG.debug("epos=" + epos.getName() + "#" + epos.toString());

        }
    }

    @Override
    public boolean isCWrapperConnected() {
        return true;
    }

    @Override
    public boolean isHardwareReady() {
        return true;
    }

    @Override
    public boolean isRealHardware() {
        return false;
    }


    @Override
    public PDOStorage readPDOs() throws FcsHardwareException, BadCommandException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/hooksController=");
        sb.append(String.valueOf(this.hooksController));
        sb.append("/carrierController=");
        sb.append(String.valueOf(this.carrierController));
        sb.append("/plutoGateway=");
        sb.append(String.valueOf(this.plutoGateway));
        return sb.toString();
    }

}
