/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.BridgeToCanOpenHardware;
import org.lsst.ccs.subsystems.fcs.common.PDOStorage;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.PDOBadResponseException;

/**
 * To list of simulated hardware for the carousel in standalone mode.
 * @author virieux
 */
public class SimuBridgeForCarousel extends BridgeToCanOpenHardware {

    private final SimuEPOSControllerModule clampXminusController;
    private final SimuEPOSControllerModule clampXplusController;
    private final SimuEPOSControllerModule carouselController;
    private final PieceOfHardware clampsSensorsReaderDevice;
    private final PieceOfHardware ai420_1;
    private final PieceOfHardware ai420_2;

    public SimuBridgeForCarousel(String aName, int aTickMillis, 
            SimuCanOpenProxy tcpProxy,
            SimuEPOSControllerModule clampActuatorXminus,
            SimuEPOSControllerModule clampActuatorXplus,
            SimuEPOSControllerModule carouselController,
            PieceOfHardware clampsSensorsReader,
            PieceOfHardware cancbxAI420_1,
            PieceOfHardware cancbxAI420_2) {
        super(aName, aTickMillis,tcpProxy);
        this.clampXminusController = clampActuatorXminus;
        this.clampXplusController = clampActuatorXplus;
        this.carouselController = carouselController;
        this.clampsSensorsReaderDevice = clampsSensorsReader;
        this.ai420_1 = cancbxAI420_1;
        this.ai420_2 = cancbxAI420_2;        
    }
    
    /**
     * Because it's a simulation, this method always returns false.
     * @return 
     */
    @Override
    public boolean isRealHardware() {
        return false;
    }
    
    /**
     * Because it's a simulation, this method always returns true.
     * @return 
     */
    @Override
    public boolean isCWrapperConnected() {
        return true;
    }

    /**
     * Because it's a simulation, this method always returns true. 
     * @return 
     */
    @Override
    public boolean isHardwareReady() {
        return true;
    }

    //TODO the simulation has not to be done at this level.
    //TODO move this method to a lower level class.
    @Override
    public PDOStorage readPDOs() throws FcsHardwareException, BadCommandException {
        String fakePDO = "23_1=25a7,23_2=113,23_3=10,23_4=109,23_5=108,23_6=104,23_7=101,23_8=112";
        try {
            this.tcpProxy.getPdoStorage().updatePDOs(fakePDO);
        } catch (PDOBadResponseException ex) {
            throw new FcsHardwareException("Simultated Carousel sent a bad PDO response.",ex);
        }
        return this.tcpProxy.getPdoStorage();
    }
    
    
}
