/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.AutoChangerTrucksModule;

/**
 * To simulate the plutoGateway on the autochanger.
 * @author virieux
 */
public class SimuAutochangerPlutoGateway extends SimuPlutoGateway {

    //private AutoChangerModule autochanger;
    //trucks controllers
    private AutoChangerTrucksModule trucks;
    //private String trucksName;
    private SimuAutochangerLinearRailController trucksController;

    //latches controllers
    private SimuAutochangerLatchController latchXminusController;
    private SimuAutochangerLatchController latchXplusController;

    //clamps controllers
    private SimuAutochangerOnlineClampController onlineClampXminusController;
    private SimuAutochangerOnlineClampController onlineClampXplusController;
    private SimuAutochangerOnlineClampController onlineClampYminusController;

    //trucks sensors
    private SimuPlutoGWSensor handoffPositionSensor0;
    private SimuPlutoGWSensor handoffPositionSensor1;
    private SimuPlutoGWSensor onlinePositionSensor0;
    private SimuPlutoGWSensor onlinePositionSensor1;
    private SimuPlutoGWSensor standbyPositionSensor0;
    private SimuPlutoGWSensor standbyPositionSensor1;
    private SimuPlutoGWSensor loaderConnectedSensor0;
    private SimuPlutoGWSensor loaderConnectedSensor1;

    //latches sensors
    private SimuPlutoGWSensor lockSensorLatchXminus;
    private SimuPlutoGWSensor unlockSensorLatchXminus;
    private SimuPlutoGWSensor filterPresenceSensorLatchXminus;
    private SimuPlutoGWSensor lockSensorLatchXplus;
    private SimuPlutoGWSensor unlockSensorLatchXplus;
    private SimuPlutoGWSensor filterPresenceSensorLatchXplus;

    //clamps sensors
    private SimuPlutoGWSensor lockSensorClampXminus;
    private SimuPlutoGWSensor lockSensorCClampXminus;
    private SimuPlutoGWSensor unlockSensorClampXminus;
    private SimuPlutoGWSensor unlockSensorCClampXminus;
    private SimuPlutoGWSensor lockSensorClampXplus;
    private SimuPlutoGWSensor lockSensorCClampXplus;
    private SimuPlutoGWSensor unlockSensorClampXplus;
    private SimuPlutoGWSensor unlockSensorCClampXplus;
    private SimuPlutoGWSensor lockSensorClampYminus;
    private SimuPlutoGWSensor lockSensorCClampYminus;
    private SimuPlutoGWSensor unlockSensorClampYminus;
    private SimuPlutoGWSensor unlockSensorCClampYminus;

    public SimuAutochangerPlutoGateway(String name, int tickMillis,
            String nodeID, String serialNB) {
        super(name, tickMillis, nodeID, serialNB);
    }

    @Override
    public void initModule() {
        super.initModule();
        this.hexaValues[0] = "00";
        this.hexaValues[1] = "00";
        this.hexaValues[2] = "00";
        this.hexaValues[3] = "00";
        this.hexaValues[4] = "00";
        this.hexaValues[5] = "00";
        //trucks
        this.handoffPositionSensor0 = (SimuPlutoGWSensor) getComponentByName("handoffPositionSensor0");
        this.handoffPositionSensor1 = (SimuPlutoGWSensor) getComponentByName("handoffPositionSensor1");
        this.onlinePositionSensor0 = (SimuPlutoGWSensor) getComponentByName("onlinePositionSensor0");
        this.onlinePositionSensor1 = (SimuPlutoGWSensor) getComponentByName("onlinePositionSensor1");
        this.standbyPositionSensor0 = (SimuPlutoGWSensor) getComponentByName("standbyPositionSensor0");
        this.standbyPositionSensor1 = (SimuPlutoGWSensor) getComponentByName("standbyPositionSensor1");
        this.loaderConnectedSensor0 = (SimuPlutoGWSensor) getComponentByName("loaderConnectedSensor0");
        this.loaderConnectedSensor1 = (SimuPlutoGWSensor) getComponentByName("loaderConnectedSensor1");
        this.trucksController = (SimuAutochangerLinearRailController) this.getComponentByName("linearRailMasterController");
        this.trucks = (AutoChangerTrucksModule) this.getComponentByName("trucks");
        simulateAutochangerTrucksIsAtStandby();

        //latches
        this.lockSensorLatchXminus = (SimuPlutoGWSensor) getComponentByName("lockSensorLatchXminus");
        this.unlockSensorLatchXminus = (SimuPlutoGWSensor) getComponentByName("unlockSensorLatchXminus");
        this.filterPresenceSensorLatchXminus = (SimuPlutoGWSensor) getComponentByName("filterPresenceSensorLatchXminus");
        this.lockSensorLatchXplus = (SimuPlutoGWSensor) getComponentByName("lockSensorLatchXplus");
        this.unlockSensorLatchXplus = (SimuPlutoGWSensor) getComponentByName("unlockSensorLatchXplus");
        this.filterPresenceSensorLatchXplus = (SimuPlutoGWSensor) getComponentByName("filterPresenceSensorLatchXplus");
        this.latchXminusController = (SimuAutochangerLatchController) this.getComponentByName("latchXminusController");
        this.latchXplusController = (SimuAutochangerLatchController) this.getComponentByName("latchXplusController");

        //clamps
        this.lockSensorClampXminus = (SimuPlutoGWSensor) getComponentByName("lockSensorClampXminus");
        this.lockSensorCClampXminus = (SimuPlutoGWSensor) getComponentByName("lockSensorCClampXminus");
        this.unlockSensorClampXminus = (SimuPlutoGWSensor) getComponentByName("unlockSensorClampXminus");
        this.unlockSensorCClampXminus = (SimuPlutoGWSensor) getComponentByName("unlockSensorCClampXminus");
        this.lockSensorClampXplus = (SimuPlutoGWSensor) getComponentByName("lockSensorClampXplus");
        this.lockSensorCClampXplus = (SimuPlutoGWSensor) getComponentByName("lockSensorCClampXplus");
        this.unlockSensorClampXplus = (SimuPlutoGWSensor) getComponentByName("unlockSensorClampXplus");
        this.unlockSensorCClampXplus = (SimuPlutoGWSensor) getComponentByName("unlockSensorCClampXplus");
        this.lockSensorClampYminus = (SimuPlutoGWSensor) getComponentByName("lockSensorClampYminus");
        this.lockSensorCClampYminus = (SimuPlutoGWSensor) getComponentByName("lockSensorCClampYminus");
        this.unlockSensorClampYminus = (SimuPlutoGWSensor) getComponentByName("unlockSensorClampYminus");
        this.unlockSensorCClampYminus = (SimuPlutoGWSensor) getComponentByName("unlockSensorCClampYminus");

        simulateFilterIsOnAutochanger();
        simulateAutochangerLatchesAreLocked();
        simulateAutochangerOnlineClampsAreUnlocked();
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerTrucksIsAtHandoff() {
        replaceDigitalValues(standbyPositionSensor0, "0");
        replaceDigitalValues(standbyPositionSensor1, "0");
        replaceDigitalValues(handoffPositionSensor0, "1");
        replaceDigitalValues(handoffPositionSensor1, "1");
        replaceDigitalValues(onlinePositionSensor0, "0");
        replaceDigitalValues(onlinePositionSensor1, "0");
        trucksController.setPosition(trucks.getHandoffPosition());
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerTrucksIsOnline() {
        replaceDigitalValues(standbyPositionSensor0, "0");
        replaceDigitalValues(standbyPositionSensor1, "0");
        replaceDigitalValues(handoffPositionSensor0, "0");
        replaceDigitalValues(handoffPositionSensor1, "0");
        replaceDigitalValues(onlinePositionSensor0, "1");
        replaceDigitalValues(onlinePositionSensor1, "1");
        trucksController.setPosition(trucks.getOnlinePosition());
        trucksController.setSsiPosition(trucks.getEncoderRibbonMinValue()
                + trucks.getOnlinePosition());
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerTrucksIsAtStandby() {
        replaceDigitalValues(standbyPositionSensor0, "1");
        replaceDigitalValues(standbyPositionSensor1, "1");
        replaceDigitalValues(handoffPositionSensor0, "0");
        replaceDigitalValues(handoffPositionSensor1, "0");
        replaceDigitalValues(onlinePositionSensor0, "0");
        replaceDigitalValues(onlinePositionSensor1, "0");
        trucksController.setPosition(trucks.getStandbyPosition());
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerTrucksIsInTravel() {
        replaceDigitalValues(standbyPositionSensor0, "0");
        replaceDigitalValues(standbyPositionSensor1, "0");
        replaceDigitalValues(handoffPositionSensor0, "0");
        replaceDigitalValues(handoffPositionSensor1, "0");
        replaceDigitalValues(onlinePositionSensor0, "0");
        replaceDigitalValues(onlinePositionSensor1, "0");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderIsConnected() {
        replaceDigitalValues(loaderConnectedSensor0, "1");
        replaceDigitalValues(loaderConnectedSensor1, "1");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateLoaderIsDisconnected() {
        replaceDigitalValues(loaderConnectedSensor0, "0");
        replaceDigitalValues(loaderConnectedSensor1, "0");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateFilterIsOnAutochanger() {
        replaceDigitalValues(filterPresenceSensorLatchXminus, "1");
        replaceDigitalValues(filterPresenceSensorLatchXplus, "1");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerIsEmpty() {
        replaceDigitalValues(filterPresenceSensorLatchXminus, "0");
        replaceDigitalValues(filterPresenceSensorLatchXplus, "0");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerLatchesAreLocked() {
        replaceDigitalValues(lockSensorLatchXminus, "1");
        replaceDigitalValues(unlockSensorLatchXminus, "0");
        replaceDigitalValues(lockSensorLatchXplus, "1");
        replaceDigitalValues(unlockSensorLatchXplus, "0");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerLatchIsLocked(String latchName) {
        if (latchName.contains("Xminus")) {
            replaceDigitalValues(lockSensorLatchXminus, "1");
            replaceDigitalValues(unlockSensorLatchXminus, "0");
        } else if (latchName.contains("Xplus")) {
            replaceDigitalValues(lockSensorLatchXplus, "1");
            replaceDigitalValues(unlockSensorLatchXplus, "0");
        }
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerLatchIsUnlocked(String latchName) {
        if (latchName.contains("Xminus")) {
            replaceDigitalValues(lockSensorLatchXminus, "0");
            replaceDigitalValues(unlockSensorLatchXminus, "1");
        } else if (latchName.contains("Xplus")) {
            replaceDigitalValues(lockSensorLatchXplus, "0");
            replaceDigitalValues(unlockSensorLatchXplus, "1");
        }
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerOnlineClampsAreLocked() {
        simulateAutochangerOnlineClampXminusIsLocked();
        simulateAutochangerOnlineClampXplusIsLocked();
        simulateAutochangerOnlineClampYminusIsLocked();
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerOnlineClampsAreUnlocked() {
        simulateAutochangerOnlineClampXminusIsUnlocked();
        simulateAutochangerOnlineClampXplusIsUnlocked();
        simulateAutochangerOnlineClampYminusIsUnlocked();
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerOnlineClampIsLocked(SimuPlutoGWSensor lockSensor,
            SimuPlutoGWSensor lockSensorC,
            SimuPlutoGWSensor unlockSensor,
            SimuPlutoGWSensor unlockSensorC) {
        replaceDigitalValues(lockSensor, "1");
        replaceDigitalValues(lockSensorC, "0");
        replaceDigitalValues(unlockSensor, "0");
        replaceDigitalValues(unlockSensorC, "1");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerOnlineClampIsUnlocked(SimuPlutoGWSensor lockSensor,
            SimuPlutoGWSensor lockSensorC,
            SimuPlutoGWSensor unlockSensor,
            SimuPlutoGWSensor unlockSensorC) {
        replaceDigitalValues(lockSensor, "0");
        replaceDigitalValues(lockSensorC, "1");
        replaceDigitalValues(unlockSensor, "1");
        replaceDigitalValues(unlockSensorC, "0");
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerOnlineClampXminusIsLocked() {
        simulateAutochangerOnlineClampIsLocked(lockSensorClampXminus,
                lockSensorCClampXminus,
                unlockSensorClampXminus,
                unlockSensorCClampXminus);
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerOnlineClampXminusIsUnlocked() {
        simulateAutochangerOnlineClampIsUnlocked(lockSensorClampXminus,
                lockSensorCClampXminus,
                unlockSensorClampXminus,
                unlockSensorCClampXminus);
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerOnlineClampXplusIsLocked() {
        simulateAutochangerOnlineClampIsLocked(lockSensorClampXplus,
                lockSensorCClampXplus,
                unlockSensorClampXplus,
                unlockSensorCClampXplus);
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerOnlineClampXplusIsUnlocked() {
        simulateAutochangerOnlineClampIsUnlocked(lockSensorClampXplus,
                lockSensorCClampXplus,
                unlockSensorClampXplus,
                unlockSensorCClampXplus);
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerOnlineClampYminusIsLocked() {
        simulateAutochangerOnlineClampIsLocked(lockSensorClampYminus,
                lockSensorCClampYminus,
                unlockSensorClampYminus,
                unlockSensorCClampYminus);
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1)
    public void simulateAutochangerOnlineClampYminusIsUnlocked() {
        simulateAutochangerOnlineClampIsUnlocked(lockSensorClampYminus,
                lockSensorCClampYminus,
                unlockSensorClampYminus,
                unlockSensorCClampYminus);
    }
}
