/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.subsystems.fcs.ADCModule;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;

/**
 * To simulate an ADC device.
 * An ADC device is used by the carousel to read the clamps sensors.
 * @author virieux
 */
public class SimuADCDevice extends ADCModule implements PieceOfHardware {
    
    private final CanOpenDevice deviceDelegate;
    
    public SimuADCDevice(String name, int tickMillis,
            String nodeID, String serialNB) {
        super(name, tickMillis);
        this.deviceDelegate = new CanOpenDevice(name, tickMillis, nodeID, serialNB);
    }

    @Override
    public String readAnalogInput(int inputNB) throws SDORequestException, HardwareNotDetectedException, ShortResponseToSDORequestException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public double readVoltage(int inputNB) throws SDORequestException, HardwareNotDetectedException, ShortResponseToSDORequestException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public String getSerialNB() {
        return deviceDelegate.getSerialNB();
    }

    @Override
    public String getNodeID() {
        return deviceDelegate.getNodeID();
    }

    @Override
    public boolean isBooted() {
        return deviceDelegate.isBooted();
    }

    @Override
    public void setBooted(boolean aBoolean) {
        deviceDelegate.setBooted(aBoolean);
    }

    @Override
    public boolean isInitialized() {
        return deviceDelegate.isInitialized();
    }

    @Override
    public String initializeAndCheckHardware() throws FcsHardwareException {
        return this.deviceDelegate.initializeAndCheckHardware();
    }
    
}
