/*
 * To change this template, choose Tools | Templates
 * and on the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.subsystems.fcs.errors.CanOpenException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.CompactIOModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftTruckMotor;

/**
 * This represents the motor that moves an autochanger truck along its rail in
 * the single-filter-test test bench.
 *
 * @author virieux
 */
public class CanOpenTruckMotor extends SftTruckMotor {

    /**
     * The Digital Input-output which controls the motor.
     */
    private CompactIOModule dio;

    /**
     * This is the name of the DIO in the groovy file which is used in
     * initModule.
     *
     */
    private final String dioName;

    /**
     * Number of the output on the DIO8 where the motor is plugged
     * Used only to be printed.
     */
    private final int outputNumeroToStandby;
    private final int outputNumeroToStandback;

    public CanOpenTruckMotor(String name, int tickMillis,
            String dioName, int outputNumeroToStandby, int outputNumeroToStandback) {
        super(name, tickMillis);
        this.dioName = dioName;
        this.outputNumeroToStandby = outputNumeroToStandby;
        this.outputNumeroToStandback = outputNumeroToStandback;
    }
    

    @Override
    public void initModule() {
        this.dio = (CompactIOModule) this.getComponentByName(dioName);
    }

    @Override
    public String moveToStandback() throws CanOpenException, FcsHardwareException {
        this.setMovingToStandback(true);
        return dio.tcpProxy.writeSDO(dio.nodeID, "6200", "1", "1", "1");

    }

    @Override
    public String moveToStandby() throws CanOpenException, FcsHardwareException {
        this.setMovingToStandby(true);
        return dio.tcpProxy.writeSDO(dio.nodeID, "6200", "1", "1", "2");
    }

    @Override
    public String off() throws CanOpenException, FcsHardwareException {
        this.setMovingToStandback(false);
        this.setMovingToStandby(false);
        return dio.tcpProxy.writeSDO(dio.nodeID, "6200", "1", "1", "0");
    }
    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("\noutputNumeroToStandby=");
        sb.append(outputNumeroToStandby);
        sb.append("\noutputNumeroToStandback=");
        sb.append(outputNumeroToStandback);
        return sb.toString();
    }

}
