/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.subsystems.fcs.common.PDOStorage;
import org.lsst.ccs.subsystems.fcs.common.Sensor14bits;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

/**
 * This is a Model for a sensor on a can open bus which communicates over Can
 * Open protocol. The sensor is supposed to be connected to a ADC with analogics
 * input.(CAN-CBX-AI814)
 *
 * @author virieux
 */
public class CanOpenSensor14bits extends Sensor14bits {

    /**
     * The ADC on which this sensor is plugged.
     */
    protected CanOpenADC adc;

    /**
     * This is the name of the ADC in the groovy file which is used in
     * initModule.
     *
     */
    private String adcName;

    /**
     * The numero of analog input where the sensor is plugged.
     */
    protected int numOfAnalogInput;

    public CanOpenSensor14bits(String moduleName, int aTickMillis, String adcName, int numOfAnalogInput) {
        super(moduleName, aTickMillis);
        this.adcName = adcName;
        this.numOfAnalogInput = numOfAnalogInput;
    }

    /**
     * ***********************************************************************************************
     */
    /**
     * ******************** SETTERS AND GETTERS  *****************************************************
     */
    /**
     * ***********************************************************************************************
     */
    public void setAdcName(String adcName) {
        this.adcName = adcName;
    }

    public void setNumOfAnalogInput(int numOfAnalogInput) {
        this.numOfAnalogInput = numOfAnalogInput;
    }

    public CanOpenADC getAdc() {
        return adc;
    }

    public int getNumOfAnalogInput() {
        return numOfAnalogInput;
    }

    /**
     * ***********************************************************************************************
     */
    /**
     * ******************** END OF SETTERS AND GETTERS  **********************************************
     */
    /**
     * ***********************************************************************************************
     */
    @Override
    public void initModule() {
        this.adc = (CanOpenADC) this.getComponentByName(adcName);
    }

    @Override
    public int readNewValue() throws FcsHardwareException {

        String valueInHexa = adc.readAnalogInput(numOfAnalogInput);

        value = Integer.parseInt(valueInHexa, 16);
        return value;
    }

    @Override
    public int updateValue(PDOStorage pdoStorage) {
        String hexaValue = pdoStorage.getVarValue(this.adc.nodeID, Integer.toString(this.numOfAnalogInput));
        this.value = Integer.parseInt(hexaValue, 16);
        return this.value;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("/adcName=");
        sb.append(this.adcName);
        sb.append("/inputNumero=");
        sb.append(this.numOfAnalogInput);
        return sb.toString();
    }

}
