/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.common;

import java.util.List;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.command.annotations.Command;

/**
 *
 * @author virieux
 */
public interface TcpProxyInterface {

    /**
     * checkNewHardware is called by command checkStarted() in higher level
     * Modules and is executed when a command completeInitialization is sent to
     * the subsystem. The command completeInitialization is sent by the end-user
     * to complete the initialization phase when the subsystem was stopped
     * during this phase because of an error (HardwareException).
     *
     * @throws org.lsst.ccs.HardwareException
     */
    @Command(type = Command.CommandType.QUERY, level = Command.NORMAL, 
            description = "Retrieve information for booted devices and " + "checks if CANopen node ID and serial number match those" + "in description file .")
    void checkNewHardware() throws HardwareException;

    void connectHardware() throws HardwareException;

    /**
     * ***********************************************************************************************
     */
    /**
     * ******************** END OF SETTERS AND GETTERS  **********************************************
     */
    /**
     * ***********************************************************************************************
     */
    /**
     * This methods stops the CWrapper client, and the TCP server.
     */
    void disconnectHardware();

    //TODO code of checkHardwareID removed in november 2015 - to be deleted after test on testbenches.
    //        FCSLOG.info(name + " Checking nodeID and serial number for " + pieceOfHardware.getName());
    //
    //        boolean serialNBFound = false;
    //        boolean nodeIDFound = false;
    //
    //        for (int i = 0; i < this.bootedNodesNB; i++) {
    //
    //            if (!(bootedNodes.get(i) == null) && (bootedNodes.get(i).getNodeID().equalsIgnoreCase(pieceOfHardware.getNodeID()))) {
    //                //the node id of this piece of hardware has been found in the bootedNodes list.
    //                nodeIDFound = true;
    //
    //                if (pieceOfHardware.getSerialNB().equalsIgnoreCase(bootedNodes.get(i).getSerialNB())) {
    //                    //and it's the same serial ID : every thing is OK
    //                    pieceOfHardware.setBooted(true);
    //                    this.publishHardwareData(pieceOfHardware);
    //                    FCSLOG.info(pieceOfHardware.getName() + " is booted  :" + pieceOfHardware.toString());
    //                } else {
    //                    //bad serial number for this pieceOfHardware
    //                    pieceOfHardware.setBooted(false);
    //                    msg = pieceOfHardware.getName() + " has a wrong serial number. Serial number found="
    //                            + bootedNodes.get(i).getSerialNB() + ", should be=" + pieceOfHardware.getSerialNB();
    //                    FCSLOG.error(msg);
    //                    errorMessageSB.append(msg);
    //                    this.hardwareIDError = true;
    //
    //                }
    //            }
    //
    //        }
    //
    //        if (!nodeIDFound) { //perhaps this hardware has a wrong node ID
    //            pieceOfHardware.setBooted(false);
    //            for (int i = 0; i < this.bootedNodesNB; i++) {
    //                if (!(bootedNodes.get(i) == null)
    //                        && (bootedNodes.get(i).getSerialNB().equalsIgnoreCase(pieceOfHardware.getSerialNB()))) {
    //                    //the serial number of this piece of hardware has been found in the bootedNodes list
    //                    //with another node ID.
    //                    serialNBFound = true;
    //                    msg = String.format(name + ":ERROR in CONFIGURATION for HARDWARE %s"
    //                            + "- %s serial number=%s - node ID found for this serial number=",
    //                            pieceOfHardware.getName(), pieceOfHardware.getSerialNB(), bootedNodes.get(i).getNodeID());
    //                    FCSLOG.error(msg);
    //                    errorMessageSB.append(msg);
    //                    this.hardwareIDError = true;
    //                }
    //            }
    //            if (!serialNBFound) {
    //                msg = String.format(":HARDWARE NOT DETECTED - "
    //                        + "Possible power failure for node ID %s ? - "
    //                        + "(hardware:%s,serial number:%s)",
    //                        pieceOfHardware.getNodeID(), pieceOfHardware.getName(),
    //                        pieceOfHardware.getSerialNB());
    //                FCSLOG.error(msg);
    //                errorMessageSB.append(msg);
    //                this.hardwareIDError = true;
    //            }
    //
    //        }
    //    }
    /**
     * Return a String with the list of hardware expected in this subsystem.
     * For debug purpose.
     * @return
     */
    String listHardware();

    /**
     * Return an Array containing hardware names handled by this component.
     * @return
     */
    List<String> listHardwareNames();

    /**
     * Publish Data on status bus for trending data base and GUIs.
     */
    void publishData();
    
}
