/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.common;

import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

/**
 * This is an interface for a piece of hardware on a can open network. //TODO :
 * should be renamed CanOpenDevice
 *
 * @author virieux
 */
public interface PieceOfHardware {

    public String getName();

    public String getSerialNB();

    public String getNodeID();

    /**
     * @return true If this piece of hardware is booted and the nodeID on the
     * hardware is the same than the one in the Configuration DB.
     */
    public boolean isBooted();

    public void setBooted(boolean aBoolean);

    /**
     * @return true if the hardware has been initialized with success, false
     * otherwise.
     */
    public boolean isInitialized();

    //public String toString();
    /**
     * This methods write some configuration data on the hardware CPU.
     *
     * @return a message for the end user if evering is OK otherwise throws an
     * exception.
     * @throws org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException
     */
    public String initializeAndCheckHardware() throws FcsHardwareException;
    

}
