/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.common;

import java.io.Serializable;
import java.util.HashMap;
import org.lsst.ccs.subsystems.fcs.errors.PDOBadResponseException;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;


/**
 * To store the values returned by the PDO.
 *
 */
public class PDOStorage implements Serializable {
    private static final long serialVersionUID = 2487036147845829605L;
    private final String sep = "_";
    private final String varSuffixe = "ADC";
    /**
     * a hash map for the storage of the values sent from the PDO. key =
     * varSuffixe + nodeID + sep + input numero Example : ADC23_5 value =
     * value in hexa
     */
    private final HashMap<String, String> mapSensorsValues = new HashMap<>();

    /**
     * update the PDO storage in reading a PDO line.
     *
     * @param pdoLine something like : "ADC1_1=10,ADC1_2=F53B, ...."
     * @throws org.lsst.ccs.subsystems.fcs.errors.PDOBadResponseException
     */
    public void updatePDOs(String pdoLine) throws PDOBadResponseException {
        FCSLOG.finest(": pdoLine=" + pdoLine);
        String[] words = pdoLine.split(",");
        FCSLOG.finest(": words.length=" + words.length);
        for (int ix = 1; ix < words.length; ix++) {
            //example toStore= ADC1_1=10
            String[] toStore = words[ix].split("=");
            //example varName= ADC1_1
            String varName = toStore[0];
            String varValue = toStore[1];
            String[] mots = varName.split(sep);
            String nodeID = mots[0].substring(3);
            FCSLOG.finest(String.format("%nwords(%s):%s nodeID=%s", ix, words[ix], nodeID));
            if (mots.length > 1) {
                mapSensorsValues.put(varName, varValue);
            } else {
                FCSLOG.error("Received a bad response from PDO request: " + pdoLine);
                throw new PDOBadResponseException("Received a bad response from PDO request.", pdoLine);
            }
        }
    }

    public String getVarValue(String nodeID, String inputNB) {
        String token = varSuffixe + nodeID + sep + inputNB;
        return mapSensorsValues.get(token);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("PDO STORAGE:");
        sb.append("(SIZE=").append(mapSensorsValues.size()).append(")");
        sb.append(mapSensorsValues.toString());
        return sb.toString();
    }
    
}
