/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.common;

import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;

/**
 * This interface is to be implemented by every class which is a model for a hardware 
 * that is moved by an EPOSController
 * @author virieux
 */
public interface MovedByEPOSController {
    
    /**
     * Return the name of the hardware.
     * @return 
     */
    public String getName();
    
    /**
     * Return the name of the controller.
     * @return 
     */
    public String getControllerName();
    
    /**
     * Return true if the controller is in fault (an EmergencyMessage has been previously received.)
     * @return 
     */
    public boolean isControllerInFault();
    
    /**
     * 
     * @param controllerInFault 
     */
    public void setControllerInFault(boolean controllerInFault);
    
    /**
     * 
     */
    public void publishData();
    
    /**
     * This method is to be used when receiving an EmergencyMessage from the CANbus.
     * @param emcyMsg the emergency message to be processed.
     */
    public default void processEmergencyMessage(EmergencyMessage emcyMsg) {
        if (getControllerName().equals(emcyMsg.getDeviceName())) {
            String errCode = emcyMsg.getDeviceErrorCode();
            switch (errCode) {
                case ("00"):
                    FCSLOG.debug(getName() + ":faultReset ?=" + emcyMsg.toString());
                    setControllerInFault(false);
                    break;

                default:
                    FCSLOG.debug(getName() + ":EmergencyMessage received for "
                            + "my controller from CanOpenProxy=" + emcyMsg.toString());
                    setControllerInFault(true);
                }
            this.publishData();
        }
    }
}
