/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.common;

import java.util.Map;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.errors.EPOSConfigurationException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations.EposMode;

/**
 *
 * @author virieux
 */
public interface EPOSController extends PieceOfHardware {
    
    public boolean isTurnedOff();
    
    public String off() throws BadCommandException,
            ErrorInCommandExecutionException, FcsHardwareException;

    int getMaxCurrent() throws FcsHardwareException;

    int getMinCurrent() throws FcsHardwareException;

    int getMaxSpeed() throws FcsHardwareException;

    int getMaxPosition() throws FcsHardwareException;

    int getMinPosition() throws FcsHardwareException;
    
    /**
     * This methods returns true if the values of parameters stored in CPU are
     * the same than those stored in the configuration system.
     * @return 
     */
    public boolean isParametersOK();
    

    /**
     * This methods changes the mode to the new mode given as an argument. It
     * writes the new mode in the CPU of the EPOS controller and updates the
     * field mode.
     *
     * @param newMode
     * @return
     * @throws SDORequestException
     */
    String changeMode(EposMode newMode) throws SDORequestException, 
            FcsHardwareException;


    /**
     * Defines the actual position as the absolute position which value is given
     * as an argument.
     *
     * @param position
     * @throws SDORequestException
     * @throws ErrorInCommandExecutionException
     * @throws BadCommandException
     */
    @Command(type = Command.CommandType.ACTION, level = Command.ENGINEERING1,
            description = "Defines the actual position as the absolute position "
                    + "which value is given as an argument.")
    void defineAbsolutePosition(int position) throws SDORequestException, 
            ErrorInCommandExecutionException, BadCommandException, FcsHardwareException;

    int readNumberOfErrors() throws SDORequestException, 
            ShortResponseToSDORequestException, FcsHardwareException;

    String displayErrorHistory() throws SDORequestException, ShortResponseToSDORequestException,
            FcsHardwareException;

    void checkFault() throws SDORequestException, ShortResponseToSDORequestException,
            FcsHardwareException;

    /**
     * This methods writes in the CPU of the EPOS devis the values of the
     * parameters set for the mode. Usually the values of the parameters are
     * given by the configuration system.
     *
     * @param mode
     * @throws SDORequestException
     * @throws org.lsst.ccs.messaging.ErrorInCommandExecutionException
     */
    void writeParameters(EposMode mode) throws SDORequestException, 
            ErrorInCommandExecutionException, FcsHardwareException;

    /**
     * In PROFILE_POSITION mode this methods set the target position. This make
     * run the motor.
     *
     * @param aValue UNIT=mA / FORMAT=decimal the value of the current to be
     * sent.
     * @throws BadCommandException
     * @throws org.lsst.ccs.subsystems.fcs.errors.SDORequestException
     *
     */
    @Command(type = Command.CommandType.ACTION, level = Command.ENGINEERING1,
            description = "In PROFILE_POSITION mode this methods set the target position.")
    void writeTargetPosition(int aValue) throws BadCommandException, 
            SDORequestException, FcsHardwareException;

    /**
     * Write to the CPU of the EPOS a map of parameters.
     *
     * @param paramMap
     * @throws SDORequestException
     */
    void writeParameters(Map<String, Integer> paramMap) 
            throws SDORequestException, FcsHardwareException;

    /*Methods available in CURRENT mode*/
    /**
     * In current mode this methods send a current to the motor. This make run
     * the motor.
     *
     * @param aValue UNIT=mA / FORMAT=decimal the value of the current to be
     * sent.
     * @throws BadCommandException
     * @throws org.lsst.ccs.subsystems.fcs.errors.EPOSConfigurationException
     * @throws org.lsst.ccs.subsystems.fcs.errors.SDORequestException
     *
     */
    @Command(type = Command.CommandType.ACTION, level = Command.ENGINEERING1,
            description = "In current mode this methods send a current to the motor.")
    void writeCurrent(int aValue) throws BadCommandException, EPOSConfigurationException,
            SDORequestException, FcsHardwareException;

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1,
            description = "Return true if the target position has been reached.")
    public boolean isTargetPositionReached(int position) throws SDORequestException, 
            ShortResponseToSDORequestException, FcsHardwareException;

    public int readPosition() throws SDORequestException, 
            ShortResponseToSDORequestException, FcsHardwareException;

    public int readSSIPosition() throws SDORequestException, 
            ShortResponseToSDORequestException, FcsHardwareException;

    public int readCurrent() throws BadCommandException, SDORequestException,
            ShortResponseToSDORequestException, FcsHardwareException;

    public String readParameters(EposMode mode) throws SDORequestException,
            ShortResponseToSDORequestException, FcsHardwareException;

    public int readProfileVelocity() throws SDORequestException, 
            ShortResponseToSDORequestException, FcsHardwareException;

    public String enable() throws SDORequestException, FcsHardwareException;

    public boolean isEnabled() throws SDORequestException, FcsHardwareException;

    public EposMode readMode() throws SDORequestException, 
            ShortResponseToSDORequestException, FcsHardwareException;

    public void quickStop() throws SDORequestException, FcsHardwareException;

    /**
     * For every parameter to be defined for this mode this method compares the
     * values in configuration with the value stored in controller CPU and
     * throws a HardwareException if these values are not equal. values stored
     * in the controller CPU.
     *
     * @param modeInString
     * @throws HardwareException
     * @throws SDORequestException
     * @throws ShortResponseToSDORequestException
     */
    void checkParameters(String modeInString) throws HardwareException, FcsHardwareException,
            SDORequestException, ShortResponseToSDORequestException;

    void checkParameters(EposMode aMode) throws HardwareException, FcsHardwareException,
            SDORequestException, ShortResponseToSDORequestException, FcsHardwareException;

    public void writeControlWord(String f) throws SDORequestException, FcsHardwareException;

    public String shutdown() throws SDORequestException, FcsHardwareException;

    boolean checkTargetReached() throws SDORequestException, 
            ShortResponseToSDORequestException, FcsHardwareException;

    public void activateBrake() throws SDORequestException, 
            ShortResponseToSDORequestException, FcsHardwareException;

    void releaseBrake() throws SDORequestException, ShortResponseToSDORequestException,
            FcsHardwareException;

    void switchOnEnableOperation() throws SDORequestException, FcsHardwareException;

    Map<String, Integer> getParamsForCurrent();

    Map<String, Integer> getParamsForHoming();

    Map<String, Integer> getParamsForProfilePosition();

    //For GUI
    public boolean isEnabledToPublish();

    public boolean isInError();

    public String getErrorRegister();

    public String[] getErrorHistory();

    public String getModeInString();

    public String writeParameterInHexa(EPOSEnumerations.Parameter parameter, String string)
            throws SDORequestException, FcsHardwareException;

    public void disable() throws SDORequestException, ShortResponseToSDORequestException,
            FcsHardwareException;



}
