/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.common;

import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

/**
 *
 * @author virieux
 */
public interface BridgeToHardware {

    /**
     * This method returns true if the C-Wrapper is connected to the tcp proxy.
     * The C-Wrapper has to send the tcpProxy clientName as a keyword before any
     * communication can begin. So if the C-Wrapper doesn't send the good
     * keyword or if it doesn't connect to the tcp proxy, this method returns
     * false.
     * @return 
     */
    boolean isCWrapperConnected();

    /**
     *
     * @return true if this bridge is connected with real hardware, false if the
     * hardware is simulated.
     */
    boolean isRealHardware();

    /**
     * @return true if the hardware is booted, identified.
     */
    boolean isHardwareReady();

    TcpProxyInterface getTcpProxy();

    void startServer();

    void startThreadReader();

    public PDOStorage readPDOs() throws FcsHardwareException, BadCommandException;

}
