/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.common;

/**
 * The main module for the whole Filter Exchange System implements this interface.
 * In the case of the whole Filter Exchange System, when there is a carousel, an
 * autochanger and a loader, the sensors of the autochanger latches tell us if
 * the filter is held by autochanger or not.
 * When carousel or loader are in standalone mode, there is no autochanger hardware.
 * But sometimes we want to test that the hardware as if the autochanger was holding 
 * a filter. This is done usualy with a numeric switch and a sensor that can be read 
 * to know the value of the switch.
 * 
 * @author virieux
 */
public interface AutochangerHandler {
    
    /**
     * This methods returns true if the autochanger is holding a filter, false otherwise.
     * @return 
     */
    public boolean isAutochangerHoldingFilterAtSTANDBY();
    
}
