/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;

/**
 * This class represents a numeric sensor which sends a digitalValue 0 or 1.
 * This type of sensors are used in the autochanger for the rail filter presence
 * sensor : the sensors which detects if a filter is there or not on each side
 * of the rail and at standby and standback position. This is used too to
 * monitor the autochanger latches : to know if a latch is locked or unlocked.
 *
 * @author virieux
 */
public abstract class NumericSensor extends Module {

    protected int digitalValue = 0;

    public NumericSensor(String aName) {
        super(aName);
    }

    @Override
    public void initModule() {
        this.digitalValue = 0;
    }

    public int getDigitalValue() {
        //FCSLOG.debug(getName() + " GET DIGITAL VALUE= " + this.digitalValue);
        return this.digitalValue;
    }

    /**
     * update the digitalValue of this object with the
     *
     * @param hexaValueReadOnDevice
     */
    public abstract void updateValue(String hexaValueReadOnDevice);

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("/value=");
        sb.append(this.digitalValue);
        return sb.toString();
    }

    @Command(type = Command.CommandType.QUERY, level = Command.ENGINEERING1,
            description = "Returns the value of the sensor stored in memory.")
    public String printValue() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("/value=");
        sb.append(this.digitalValue);
        return sb.toString();
    }

    public abstract void updateValue(String[] hexaValues);

}
