/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;

/**
 * This is a model for the Inclinometer used in CPPM test bench.
 *
 * @author virieux
 */
public class InclinometerModule extends Module {

    private final String plutoGatewayName;
    private PlutoGatewayModule plutoGateway;
    private double inclinaison;

    public InclinometerModule(String name, int tickMillis, String plutoGatewayName) {
        super(name, tickMillis);
        this.plutoGatewayName = plutoGatewayName;
    }

    @Override
    public void initModule() {
        this.plutoGateway = (PlutoGatewayModule) getComponentByName(this.plutoGatewayName);
    }

    /**
     * Read the inclinaison on the plutoGateway, updates the filed inclinaison
     * and returns its value in degrees.
     *
     * @return inclinaison
     * @throws FcsHardwareException
     */
    public double readInclinaison() throws FcsHardwareException {
        updateInclinaison();
        return inclinaison;
    }

    public void updateInclinaison() throws FcsHardwareException {
        //the value read from the plutoGateway is in tenth of volts
        //so it has to be divided by ten to obtain the value in volt
        inclinaison = convertVoltage2Degree(plutoGateway.readNewAnalogValue() / 10);
    }

    /**
     * Concert a voltage in volt between 0.5 and 4.5 volts.
     *
     * @param voltage
     * @return
     */
    public static double convertVoltage2Degree(int voltage) {
        if (voltage < 0 || voltage > 5) {
            throw new IllegalArgumentException("Voltage has to be between 0.5 and 4.5.");
        }
        //voltage is in volt
        double sin_angle = (voltage - 2.5) / 11.52;
        return Math.toDegrees(Math.asin(sin_angle));
    }

}
