/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.Map;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.messaging.BadCommandException;
import org.lsst.ccs.messaging.ErrorInCommandExecutionException;
import org.lsst.ccs.subsystems.fcs.common.AutochangerHandler;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import static org.lsst.ccs.subsystems.fcs.FCSCst.FCSLOG;

/**
 * This class is the Main Module when carousel is in standalone mode.
 * 
 * @author virieux
 */
public class CarouselMainModule extends MainModule implements AutochangerHandler {
    
    private CarouselModule carousel;
     
    private final FilterManager filterManager;
    

    public CarouselMainModule(String aName, int aTickMillis, 
            BridgeToHardware bridge,
            FilterManager filterMg
            ) {
        super(aName, aTickMillis, bridge);
        this.filterManager = filterMg;
    }

    public FilterManager getFilterManager() {
        return filterManager;
    }

    public CarouselModule getCarousel() {
        return carousel;
    }
    
    
    
    @Override
    public void initModule() {
        carousel = (CarouselModule) this.getComponentByName("carousel");
    }
    
    @Command(type = Command.CommandType.QUERY, level = Command.NORMAL,
            description = "Return true if Autochanger is holding filter at STANDBY.")
    @Override
    public boolean isAutochangerHoldingFilterAtSTANDBY() {
        /**
         * To be done when a switch is connected : read the switch sensor and 
         * update a boolean of the class like : autochangerHoldingFilter.
         */
        return false;
    }
    
    @Command(type = Command.CommandType.QUERY, level = Command.NORMAL,
            description = "Update state in reading sensors.")
    @Override
    public void updateStateWithSensors() throws FcsHardwareException, 
            ErrorInCommandExecutionException, BadCommandException {
        super.updateStateWithSensors();
        //TODO : carousel.updateClampsStateWithSensors() doesn't work for simulation - make it work.
        //this.carousel.updateClampsStateWithSensors();
    }
    
    //TODO IN REAL LIFE : rotate carousel, identify each filter on each socket
    @Command(type = Command.CommandType.ACTION, 
            level = Command.NORMAL,
            description = "Check which filters are on Carousel and on which socket"
                    + "and update the sockets.")
    public void locateFilters() throws FcsHardwareException, BadCommandException {
        
        if (!this.controlRealHardware()) {
            FCSLOG.info(name + " locating filters.....");

            carousel.getSocketByName("socket1").putFilterOnSocket(filterManager.getFilterByName("filterU"));
            carousel.getSocketByName("socket2").putFilterOnSocket(filterManager.getFilterByName("filterG"));
            carousel.getSocketByName("socket3").putFilterOnSocket(filterManager.getFilterByName("filterR"));
            carousel.getSocketByName("socket4").putFilterOnSocket(filterManager.getFilterByName("filterI"));
            carousel.getSocketByName("socket5").putFilterOnSocket(filterManager.getFilterByName("filterZ"));
            carousel.engageClampsContact();
            
            filterManager.getFilterByName("filterY").setFilterLocation(FcsEnumerations.FilterLocation.OUT);
            Map<String,Filter> filterMap = filterManager.filtersMap;
            for (Map.Entry<String,Filter> entry: filterMap.entrySet()) {
                Filter filter = entry.getValue();
                if (!filter.isOnCarousel()) {
                    filterManager.getFilterByName(filter.getName()).setFilterLocation(FcsEnumerations.FilterLocation.OUT);
                }
            }
            
            carousel.getSocketByName("socket1").updateClampsStateWithSensorsFromSDO();
            carousel.getSocketByName("socket2").updateClampsStateWithSensorsFromSDO();
            carousel.getSocketByName("socket3").updateClampsStateWithSensorsFromSDO();
            carousel.getSocketByName("socket4").updateClampsStateWithSensorsFromSDO();
            carousel.getSocketByName("socket5").updateClampsStateWithSensorsFromSDO();
        }

    }
    
    
    
    @Override
    public void start() {
        if (!this.controlRealHardware()) {
            try {
                locateFilters();
            } catch (FcsHardwareException | BadCommandException ex) {
                FCSLOG.error(name + " error in locateFilters:" + ex);
            }
        }
    }
  
    
}
