/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.subsystems.fcs.common.Sensor14bits;
import org.lsst.ccs.subsystems.fcs.common.Thermometer;

/**
 *
 * @author virieux
 */
public class CarouselClampXminus extends CarouselClampModule {

    public CarouselClampXminus(String aName, int aTickMillis, 
            //String controllerName, 
            Sensor14bits filterPresenceSensor, Sensor14bits lockSensor, 
            Thermometer thermometer, 
            int filterPositionValueA, int filterPositionValueB, int filterPositionValueC, 
            int filterPositionOffset, 
            int lockSensorValueA, int lockSensorValueB, int lockSensorValueC, int lockSensorOffset, 
            int timeoutForUnlocking, int timeoutForReleasing, 
            int currentToUnlock, int currentToMaintainUnlocked) {
        super(aName, aTickMillis, //controllerName, 
                filterPresenceSensor, lockSensor, 
                thermometer, filterPositionValueA, filterPositionValueB, filterPositionValueC, 
                filterPositionOffset, lockSensorValueA, lockSensorValueB, lockSensorValueC, 
                lockSensorOffset, timeoutForUnlocking, timeoutForReleasing, 
                currentToUnlock, currentToMaintainUnlocked);
    }


    
    @Override
    public FcsEnumerations.FilterClampState computeClampState() {

        FcsEnumerations.FilterClampState state = super.computeClampState();
        if (state.equals(FcsEnumerations.FilterClampState.UNCLAMPEDEMPTY) 
                && this.controller.isTurnedOff()) {
            return FcsEnumerations.FilterClampState.READYTOCLAMP;
        } else {
            return state;
        }
    }
    
}
