#!/bin/sh
#
# CCS worker subsystem startup template
#-----------------------------------------------------------
#-- project specifics
proj=org-lsst-ccs-subsystem-fcs-main
echo "proj=$proj"
pkg=org.lsst.ccs.startup
echo "package=$pkg"
mclass=SubsystemBoot
echo "main class=$mclass"
#dfile=<mandatory descriptionfile>
echo "description file=$dfile"
dfile=single-filter-test__hardware
#cfile=<optional-cfgfile>
cfile=
#- example
#dfile=etc/new-ccs-vst
#cfile=
#
#-- get canonical paths, note if readlink fails, falls back to $0
#
rpath=$(readlink -fn $0 2>/dev/null) || rpath=$0
echo "rpath=$rpath"
rname=${rpath##*/}       #- name comes after last /
echo "rname=$rname"
rdir=${rpath%/*}         #- dirname of this script
echo "rdir=$rdir"
bdir=${rdir%/*}          #- base dir with {bin,lib,etc,share,...}
echo "bdir=$bdir"
if [ ! -e ${bdir}/share/java ]; then
	   echo "error:" bad path $0, ${bdir}/share/java not found
	      exit 1
      fi

      #-- get the last jar file in std sort order (eg 1.1 is after 1.0)
      jar=$(ls -1 $bdir/share/java/${proj}*jar | sed '$ !d')
      echo "jar=$jar"


      #-- set LD_LIBRARY_PATH for distribution standard
      LDP=${bdir}/lib/jni:${bdir}/lib

      #-- cfile option
      if [ "XXX"${cfile} != "XXX" ]; then 
	      CFG=" --configfile ${cfile}"
      fi

      #-- run the CLASS
      
      echo "LD_LIBRARY_PATH=${LDP} java -cp ${jar} ${pkg}.${mclass} --description $dfile $CFG"
      LD_LIBRARY_PATH=${LDP} java -cp ${jar} ${pkg}.${mclass} --description $dfile $CFG
