/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import java.beans.ConstructorProperties;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.LoaderModule;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderConfig;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class LoaderTestBenchMainModule
extends MainModule {
    private LoaderModule loader;
    private AutoChangerModule autochanger;
    private final NumericSensor autochangerHoldingFilterSensor;

    @ConstructorProperties(value={"name", "tickmillis", "bridge", "autochangerHoldingFilterSensor"})
    public LoaderTestBenchMainModule(String aName, int aTickMillis, BridgeToHardware bridge, NumericSensor autochangerHoldingFilterSensor) {
        super(aName, aTickMillis, bridge);
        this.autochangerHoldingFilterSensor = autochangerHoldingFilterSensor;
    }

    public LoaderModule getLoader() {
        return this.loader;
    }

    @Override
    public void initModule() {
        super.initModule();
        this.loader = (LoaderModule)this.getModule("loader");
        this.autochanger = (AutoChangerModule)this.getModule("autochanger");
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Load a filter from the loader into the camera.")
    public String loadFilterInCamera() throws BadCommandException, FcsHardwareException, ErrorInCommandExecutionException, InterruptedException {
        return this.loader.loadFilterInCamera();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Unload a filter from the camera into the loader.")
    public String unloadFilterFromCamera() throws BadCommandException, FcsHardwareException, InterruptedException, SDORequestException, ErrorInCommandExecutionException {
        return this.loader.unloadFilterFromCamera();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Open the loader clamp.")
    public String openHooks() throws SDORequestException, BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        return this.loader.openHooks();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Close the loader clamp.")
    public String closeHooks() throws BadCommandException, SDORequestException, ErrorInCommandExecutionException, FcsHardwareException {
        return this.loader.closeHooks();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Clamp the loader clamp.")
    public String clampHooks() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        return this.loader.clampHooks();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=0, description="Update loader state in reading the sensors.")
    public void updateStateWithSensors() throws FcsHardwareException, ErrorInCommandExecutionException, BadCommandException {
        super.updateStateWithSensors();
        this.loader.updateStateWithSensors();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Carrier go to Handoff.")
    public String goToHandoff() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        return this.loader.goToHandoff();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Carrier go to Storage.")
    public String goToStorage() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        return this.loader.goToStorage();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="List and display hooks sensors.")
    public String listHooksSensors() {
        return this.loader.getClamp().listHooks();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="List and display the hooks sensors values.")
    public String listSensorsValues() {
        return this.loader.getClamp().listSensorsValues();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="The GUIs need that for the initialization.")
    public LoaderConfig getFullState() {
        try {
            return FcsUtils.createLoaderConfig(this);
        }
        catch (Exception e) {
            log.error((Object)e, new String[0]);
            return null;
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("\n").append(((Object)((Object)this.loader)).toString());
        sb.append("\n").append(this.autochangerHoldingFilterSensor.toString());
        return sb.toString();
    }
}

