/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.testbench.LPC;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.subsystems.fcs.common.Thermometer;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenSensor14bits;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.HardwareNotDetectedException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;
import org.lsst.ccs.subsystems.fcs.testbench.LPC.HygrometrySensor;
import org.lsst.ccs.subsystems.fcs.testbench.LPC.PressureSensor;

public class CanOpenLPCGaugeHD2001
extends CanOpenSensor14bits
implements Thermometer,
PressureSensor,
HygrometrySensor {
    private final int offsetTemp;
    private final int offsetPressure;
    private double temperature;

    public CanOpenLPCGaugeHD2001(String moduleName, int aTickMillis, String adcName, int numOfAnalogInput, int offsetTemp, int offsetPressure) {
        super(moduleName, aTickMillis, adcName, numOfAnalogInput);
        this.offsetTemp = offsetTemp;
        this.offsetPressure = offsetPressure;
    }

    @Override
    public double readTemperature() throws SDORequestException, HardwareNotDetectedException {
        try {
            double voltage = this.getAdc().readVoltage(this.getNumOfAnalogInput());
            this.temperature = voltage / 100.0 + (double)this.offsetTemp;
        }
        catch (ShortResponseToSDORequestException ex) {
            fcslog.warning((Object)(String.valueOf(this.name) + " couldn't read temperature : " + ex.getMessage()), new String[0]);
        }
        return this.temperature;
    }

    @Override
    public double readTemperatureWithPDO(CanOpenProxy.PDOStorage pdo) throws BadCommandException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double readPressure() throws FcsHardwareException {
        double voltage = this.getAdc().readVoltage(this.getNumOfAnalogInput());
        return voltage / 500.0 + (double)this.offsetPressure;
    }

    @Override
    public double readHygrometry() throws FcsHardwareException {
        double voltage = this.getAdc().readVoltage(this.getNumOfAnalogInput());
        return voltage / 100.0;
    }
}

