/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.testbench;

import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.AutoChangerModule;
import org.lsst.ccs.subsystems.fcs.AutoChangerTrucksModule;
import org.lsst.ccs.subsystems.fcs.AutochangerOnlineClampModule;
import org.lsst.ccs.subsystems.fcs.InclinometerModule;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.PlutoGatewayModule;
import org.lsst.ccs.subsystems.fcs.autochanger.config.AutochangerConfig;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class CPPMTestBenchMainModule
extends MainModule {
    private final InclinometerModule inclinometer;
    private final AutochangerOnlineClampModule onlineClamp;
    private final AutoChangerModule autochanger;
    private final String plutoGatewayName;
    private PlutoGatewayModule plutoGateway;
    EPOSController latchController;

    public CPPMTestBenchMainModule(String aName, int aTickMillis, BridgeToHardware aBridge, InclinometerModule inclinometer, AutochangerOnlineClampModule onlineClamp, AutoChangerModule autochanger, String plutoGatewayName) {
        super(aName, aTickMillis, aBridge);
        this.inclinometer = inclinometer;
        this.onlineClamp = onlineClamp;
        this.autochanger = autochanger;
        this.plutoGatewayName = plutoGatewayName;
    }

    public EPOSController getLinearRailMasterController() {
        return this.autochanger.getTrucks().getLinearRailMasterController();
    }

    public EPOSController getLinearRailSlaveController() {
        return this.autochanger.getTrucks().getLinearRailSlaveController();
    }

    public EPOSController getOnlineClampController() {
        return this.onlineClamp.getOnlineClampController();
    }

    public EPOSController getLatchController() {
        return this.latchController;
    }

    public PlutoGatewayModule getPlutoGateway() {
        return this.plutoGateway;
    }

    public AutoChangerTrucksModule getAutochangerTrucks() {
        return this.autochanger.getTrucks();
    }

    @Override
    public void initModule() {
        super.initModule();
        this.plutoGateway = (PlutoGatewayModule)this.getModule(this.plutoGatewayName);
        this.latchController = (EPOSController)this.getModule("latchXminusController");
    }

    @Override
    public void updateStateWithSensors() throws FcsHardwareException, ErrorInCommandExecutionException, BadCommandException {
        super.updateStateWithSensors();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="The GUIs need that for the initialization.")
    public AutochangerConfig getFullState() {
        try {
            return FcsUtils.createAutochangerConfig(this);
        }
        catch (Exception e) {
            log.error((Object)e, new String[0]);
            return null;
        }
    }
}

