/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import java.util.List;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.CarouselSocket;
import org.lsst.ccs.subsystems.fcs.Filter;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.SftMainModule;

public class SftCarouselModule
extends CarouselModule {
    public SftCarouselModule(String aName, int aTickMillis, int nbSockets, List<CarouselSocket> socketsList) {
        super(aName, aTickMillis, nbSockets, socketsList);
    }

    @Override
    public CarouselSocket getSocketAtStandby() {
        return this.getSockets()[0];
    }

    @Override
    public double getPosition() {
        return 0.0;
    }

    @Command(level=0, description="Read clamps sensors, update clamps state and sockets field", type=Command.CommandType.QUERY, alias="updState")
    public void updateStateWithSensors() throws FcsHardwareException, BadCommandException {
        if (this.getSocketAtStandby() == null) {
            throw new BadCommandException("Unable to read sensors when there is no socket at standby.");
        }
        this.updateClampsStateWithSensors();
        Filter dummyFilter = ((SftMainModule)this.getModule("main")).getDummyFilter();
        if (this.getSocketAtStandby().isClampedOnFilter() || this.getSocketAtStandby().isUnclampedOnFilter()) {
            this.getSocketAtStandby().putFilterOnSocket(dummyFilter);
        } else if (this.getSocketAtStandby().getFilter() != null) {
            this.getSocketAtStandby().removeFilter();
        }
        this.publishData();
    }

    @Override
    @Command(level=0, description="Read clamps sensors, update clamps state", type=Command.CommandType.QUERY, alias="updClampsState")
    public void updateClampsStateWithSensors() throws BadCommandException, FcsHardwareException {
        this.updateClampsStateWithSensorsFromPDO();
    }

    @Override
    public boolean isAbleToMove() {
        return false;
    }

    @Override
    public boolean isRotating() {
        return false;
    }

    @Override
    public String rotate(double angle) {
        throw new UnsupportedOperationException("Operation rotate not available in Single Filter Test");
    }

    @Override
    public String engageBrake() {
        throw new UnsupportedOperationException("Operation not available in Single Filter Test");
    }

    @Override
    public String releaseBrake() {
        throw new UnsupportedOperationException("Operation not available in Single Filter Test");
    }
}

