/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest;

import java.util.concurrent.locks.Condition;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.MainModule;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.common.FilterLatch;
import org.lsst.ccs.subsystems.fcs.common.MobileItemModule;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.CompactIOModule;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.LatchActuatorModule;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class FilterLatchModule
extends MobileItemModule
implements FilterLatch {
    private boolean filterEngaged;
    private boolean locked;
    private boolean unlocked;
    private boolean inError;
    private FcsEnumerations.FilterPresenceInLatchStatus presenceStatus;
    private FcsEnumerations.LockStatus lockStatus;
    LatchActuatorModule latchActuator;
    protected NumericSensor filterPresenceSensor;
    protected NumericSensor lockSensor;
    protected NumericSensor unlockSensor;
    CompactIOModule filterSensorsDIO;
    String filterSensorsDIOName;
    final Condition stateUpdated;
    protected volatile boolean updatingState;
    private long timeoutForOpening;
    private long timeoutForClosing;

    public FilterLatchModule(String moduleName, int aTickMillis, long timeoutForClosing, long timeoutForOpening, String filterSensorsDIOName, NumericSensor lockSensor, NumericSensor unlockSensor, NumericSensor filterPresenceSensor, LatchActuatorModule latchActuator) {
        super(moduleName, aTickMillis);
        this.stateUpdated = this.lock.newCondition();
        this.updatingState = false;
        this.timeoutForClosing = timeoutForClosing;
        this.timeoutForOpening = timeoutForOpening;
        this.filterSensorsDIOName = filterSensorsDIOName;
        this.lockSensor = lockSensor;
        this.unlockSensor = unlockSensor;
        this.filterPresenceSensor = filterPresenceSensor;
        this.latchActuator = latchActuator;
    }

    @ConfigChanger
    public void setTimeoutForClosing(long timeoutForClosing) {
        this.timeoutForClosing = timeoutForClosing;
    }

    @ConfigChanger
    public void setTimeoutForOpening(long timeoutForOpening) {
        this.timeoutForOpening = timeoutForOpening;
    }

    public long getTimeoutForClosing() {
        return this.timeoutForClosing;
    }

    public long getTimeoutForOpening() {
        return this.timeoutForOpening;
    }

    @Override
    public NumericSensor getFilterPresenceSensor() {
        return this.filterPresenceSensor;
    }

    public LatchActuatorModule getLatchActuator() {
        return this.latchActuator;
    }

    @Override
    public NumericSensor getLockSensor() {
        return this.lockSensor;
    }

    @Override
    public NumericSensor getUnlockSensor() {
        return this.unlockSensor;
    }

    @Override
    public boolean isControllerInFault() {
        return false;
    }

    public void initModule() {
        this.filterSensorsDIO = (CompactIOModule)this.getModule(this.filterSensorsDIOName);
        this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
        this.presenceStatus = FcsEnumerations.FilterPresenceInLatchStatus.UNKNOWN;
        this.filterEngaged = false;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="Returns true if hardware is connected and ready.")
    public boolean isHardwareReady() {
        return ((MainModule)this.getModule("main")).isHardwareReady();
    }

    @Override
    public boolean isActionCompleted(FcsEnumerations.MobileItemAction action) {
        if (action.equals((Object)FcsEnumerations.MobileItemAction.OPEN)) {
            return this.getLockStatus().equals((Object)FcsEnumerations.LockStatus.UNLOCKED);
        }
        if (action.equals((Object)FcsEnumerations.MobileItemAction.CLOSE)) {
            return this.getLockStatus().equals((Object)FcsEnumerations.LockStatus.LOCKED);
        }
        throw new IllegalArgumentException("Action on latch must be OPEN or CLOSE");
    }

    @Override
    public void updateStateWithSensorsToCheckIfActionIsCompleted() throws Exception {
        this.updateStateWithSensors();
    }

    @Command(level=1, description="Read latch sensors and update latch state", type=Command.CommandType.QUERY)
    public void updateStateWithSensors() throws Exception {
        this.filterSensorsDIO.updateValue();
        String filterSensorsHexaValue = this.filterSensorsDIO.getHexaValue();
        this.updateState(filterSensorsHexaValue);
    }

    @Override
    public void startAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        if (action.equals((Object)FcsEnumerations.MobileItemAction.OPEN)) {
            this.latchActuator.open();
        } else if (action.equals((Object)FcsEnumerations.MobileItemAction.CLOSE)) {
            this.latchActuator.close();
        } else {
            throw new IllegalArgumentException(String.valueOf(this.getName()) + "Action on latch must be OPEN or CLOSE");
        }
    }

    @Override
    public void abortAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void postAction(FcsEnumerations.MobileItemAction action) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
    }

    /*
     * Exception decompiling
     */
    @Override
    public FcsEnumerations.LockStatus getLockStatus() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setLockStatus(FcsEnumerations.LockStatus lockStatus) {
        this.lockStatus = lockStatus;
    }

    /*
     * Exception decompiling
     */
    public FcsEnumerations.FilterPresenceInLatchStatus getPresenceStatus() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public StatusDataPublishedByAutochangerLatch getStatusData() {
        StatusDataPublishedByAutochangerLatch status = FcsUtils.createStatusDataPublishedByLatch(this);
        return status;
    }

    @Command(level=3, description="Open latch", type=Command.CommandType.ACTION)
    public String open() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException, Exception {
        this.updateStateWithSensors();
        if (!this.isLocked()) {
            return String.valueOf(this.getName()) + "is already OPEN";
        }
        CarouselModule carousel = (CarouselModule)this.environment.getComponentByName("carousel");
        if (!carousel.isHoldingFilterAtStandby()) {
            throw new BadCommandException(String.valueOf(this.getName()) + "CANNOT OPEN LATCH at STANDBY : CAROUSEL is NOT HOLDING THE FILTER");
        }
        this.executeAction(FcsEnumerations.MobileItemAction.OPEN, this.timeoutForOpening);
        this.latchActuator.powerOff();
        return String.valueOf(this.getName()) + " is OPEN";
    }

    @Command(level=3, description="Close latch", type=Command.CommandType.ACTION)
    public String close() throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException, Exception {
        this.updateStateWithSensors();
        if (this.isLocked()) {
            return String.valueOf(this.getName()) + "is already CLOSED";
        }
        this.executeAction(FcsEnumerations.MobileItemAction.CLOSE, this.timeoutForClosing);
        this.latchActuator.powerOff();
        return String.valueOf(this.getName()) + " is CLOSED";
    }

    @Command(level=1, description="Return true if the latch is closed", type=Command.CommandType.QUERY)
    public boolean isLocked() {
        return this.getLockStatus().equals((Object)FcsEnumerations.LockStatus.LOCKED);
    }

    public void updateState(String hexaValue) {
        this.lock.lock();
        try {
            this.updatingState = true;
            this.filterPresenceSensor.updateValue(hexaValue);
            this.lockSensor.updateValue(hexaValue);
            this.unlockSensor.updateValue(hexaValue);
            if (this.filterPresenceSensor.getDigitalValue() == 1) {
                this.filterEngaged = true;
                this.presenceStatus = FcsEnumerations.FilterPresenceInLatchStatus.ENGAGED;
            } else {
                this.filterEngaged = false;
                this.presenceStatus = FcsEnumerations.FilterPresenceInLatchStatus.NOFILTER;
            }
            this.locked = this.lockSensor.getDigitalValue() == 1;
            this.unlocked = this.unlockSensor.getDigitalValue() == 1;
            boolean bl = this.inError = this.locked && this.unlocked;
            this.lockStatus = this.inError ? FcsEnumerations.LockStatus.ERROR : (this.locked ? FcsEnumerations.LockStatus.LOCKED : (this.unlocked ? FcsEnumerations.LockStatus.UNLOCKED : FcsEnumerations.LockStatus.UNKNOWN));
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
        }
        this.publishData();
    }

    @Override
    public void publishData() {
        StatusDataPublishedByAutochangerLatch status = this.getStatusData();
        this.publish("autochangerLatch", status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/ lock sensor=");
        sb.append(this.lockSensor.getName());
        sb.append("/ unlock sensor=");
        sb.append(this.unlockSensor.getName());
        sb.append("/ filter presence sensor=");
        sb.append(this.filterPresenceSensor.getName());
        return sb.toString();
    }

    @Override
    public void quickStopAction(FcsEnumerations.MobileItemAction action, long delay) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static class LatchError
    extends Exception {
        FilterLatchModule latch;

        public LatchError(String string, FilterLatchModule aThis) {
            super(string);
            this.latch = aThis;
        }
    }
}

