/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.PlutoGatewayModule;
import org.lsst.ccs.subsystems.fcs.common.PieceOfHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenDevice;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuPlutoGWSensor;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class SimuPlutoGateway
extends PlutoGatewayModule
implements PieceOfHardware {
    CanOpenDevice deviceDelegate;

    public SimuPlutoGateway(String name, int tickMillis, String nodeID, String serialNB) {
        super(name, tickMillis);
        this.deviceDelegate = new CanOpenDevice(name, tickMillis, nodeID, serialNB);
    }

    @Override
    public void initModule() {
        super.initModule();
        this.hexaValues[0] = "00";
        this.hexaValues[1] = "00";
        this.hexaValues[2] = "00";
        this.hexaValues[3] = "00";
        this.hexaValues[4] = "00";
        this.hexaValues[5] = "00";
    }

    @Override
    public int readNewAnalogValue() throws FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String[] readNewHexaValues() {
        return this.hexaValues;
    }

    public void replaceDigitalValues(SimuPlutoGWSensor sensor, String digitalValue) {
        this.lock.lock();
        try {
            this.updatingValues = true;
            int byteNo = sensor.getByteNumero();
            fcslog.finest((Object)(String.valueOf(this.name) + "=> old hexa value = " + this.hexaValues[byteNo]), new String[0]);
            StringBuilder bin = new StringBuilder(FcsUtils.hexToBinary(this.hexaValues[byteNo]));
            bin.replace(7 - sensor.getInputNumero(), 7 - sensor.getInputNumero() + 1, digitalValue);
            String newDIOHexaValue = Integer.toHexString(Integer.parseInt(bin.toString(), 2));
            fcslog.finest((Object)(String.valueOf(this.name) + "=> new hexa value =" + newDIOHexaValue), new String[0]);
            this.hexaValues[byteNo] = newDIOHexaValue;
            fcslog.finest((Object)(String.valueOf(this.name) + " HEXA VALUE READ: hexaValues[0]=" + this.hexaValues[0] + " hexaValues[1]=" + this.hexaValues[1]), new String[0]);
        }
        finally {
            this.updatingValues = false;
            this.valueUpdated.signal();
            this.lock.unlock();
        }
    }

    @Override
    public String getSerialNB() {
        return this.deviceDelegate.getSerialNB();
    }

    @Override
    public String getNodeID() {
        return this.deviceDelegate.getNodeID();
    }

    @Override
    public boolean isBooted() {
        return this.deviceDelegate.isBooted();
    }

    @Override
    public void setBooted(boolean aBoolean) {
        this.deviceDelegate.setBooted(aBoolean);
    }

    @Override
    public boolean isInitialized() {
        return this.deviceDelegate.isInitialized();
    }

    @Override
    public String initializeHardware() throws FcsHardwareException {
        return this.deviceDelegate.initializeHardware();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="For tests purpose - raise an alarm.")
    public void simulateAlarm(String alarmMsg) {
        log.debug((Object)(String.valueOf(this.name) + "An Alarm was raised:" + alarmMsg), new String[0]);
        this.getSubsystem().raiseAlarm(alarmMsg);
    }
}

