/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.subsystems.fcs.simulation.SimuNumericSensor;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.CompactIOModule;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class SimuCompactIOModule
extends CompactIOModule {
    String initialHexaValue;
    SimuNumericSensor filterPresenceSensorLatchXminus;
    SimuNumericSensor filterPresenceSensorLatchXplus;

    public String getInitialHexaValue() {
        return this.initialHexaValue;
    }

    public void setInitialHexaValue(String initialHexaValue) {
        this.initialHexaValue = initialHexaValue;
    }

    public void setHexaValue(String hex) {
        this.hexaValue = hex;
    }

    @Override
    public void initModule() {
        this.hexaValue = this.initialHexaValue;
        this.filterPresenceSensorLatchXminus = (SimuNumericSensor)this.getModule("filterPresenceSensorLatchXminus");
        this.filterPresenceSensorLatchXplus = (SimuNumericSensor)this.getModule("filterPresenceSensorLatchXplus");
    }

    @Override
    public String readNewHexaValue() {
        return this.hexaValue;
    }

    @Override
    public int readNewValue() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void simulateFilterPresenceInLatches(String aDigitalValue) {
        int inputNumeroXminus = this.filterPresenceSensorLatchXminus.getInputNumero();
        int inputNumeroXplus = this.filterPresenceSensorLatchXplus.getInputNumero();
        this.replaceDigitalValues(inputNumeroXminus, aDigitalValue, inputNumeroXplus, aDigitalValue);
    }

    public void replaceDigitalValues(int channel1, String digitalValue1, int channel2, String digitalValue2) {
        if (channel1 < 1 || channel1 > 8) {
            throw new IllegalArgumentException("bad value for channel1 : Channel numero has to be between 1 and 8.");
        }
        if (channel2 < 1 || channel2 > 8) {
            throw new IllegalArgumentException("bad value for channel2 : Channel numero has to be between 1 and 8.");
        }
        if (!digitalValue1.equals("0") && !digitalValue1.equals("1")) {
            throw new IllegalArgumentException("digitalValue1 has to be a String equals \"0\" or \"1\". ");
        }
        if (!digitalValue2.equals("0") && !digitalValue2.equals("1")) {
            throw new IllegalArgumentException("digitalValue1 has to be a String equals \"0\" or \"1\". ");
        }
        fcslog.debug((Object)(String.valueOf(this.getName()) + "=> old hexa value = " + this.hexaValue), new String[0]);
        StringBuilder bin = new StringBuilder(FcsUtils.hexToBinary(this.hexaValue));
        bin.replace(8 - channel1, 8 - channel1 + 1, digitalValue1);
        bin.replace(8 - channel2, 8 - channel2 + 1, digitalValue2);
        String newDIOHexaValue = Integer.toHexString(Integer.parseInt(bin.toString(), 2));
        fcslog.debug((Object)(String.valueOf(this.getName()) + "=> new hexa value =" + newDIOHexaValue), new String[0]);
        this.hexaValue = newDIOHexaValue;
    }
}

