/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import java.util.Random;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.bus.KVList;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.CarouselModule;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClampActuator;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.errors.EPOSConfigurationException;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.errors.ShortResponseToSDORequestException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuClampLockSensor;
import org.lsst.ccs.subsystems.fcs.simulation.SimuFilterClampModule;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class SimuClampActuatorModule
extends Module
implements EPOSController {
    protected static final Logger fcslog = FcsUtils.log;
    public boolean on;
    boolean enabled;
    public int readCurrentValue;
    public int sentCurrentValue;
    public int sentCurrentMinValue;
    public int sentCurrentMaxValue;
    EPOSEnumerations.EposMode mode;
    int current;
    Random r = new Random();
    CarouselModule carousel;

    @Override
    public boolean isOn() {
        return this.on;
    }

    @Override
    public boolean isOff() {
        return !this.on;
    }

    @Override
    public int getReadActualCurrent() {
        return this.readCurrentValue;
    }

    @Override
    public int getSentCurrentMinValue() {
        return this.sentCurrentMinValue;
    }

    @Override
    public int getSentCurrentMaxValue() {
        return this.sentCurrentMaxValue;
    }

    public void initModule() {
        this.on = false;
        this.carousel = (CarouselModule)this.getModule("carousel");
        this.mode = EPOSEnumerations.EposMode.CURRENT;
    }

    @Override
    public String on() throws BadCommandException, ErrorInCommandExecutionException {
        SimuFilterClampModule clamp;
        this.on = true;
        fcslog.debug((Object)(String.valueOf(this.getName()) + "==========> ACTUATOR ON"), new String[0]);
        if (this.getName().contains("Xminus")) {
            clamp = (SimuFilterClampModule)this.carousel.getClampXminus();
        } else if (this.getName().contains("Xplus")) {
            clamp = (SimuFilterClampModule)this.carousel.getClampXplus();
        } else {
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + ": unable to find the clamp to unlock.");
        }
        ((SimuClampLockSensor)clamp.getLockSensor()).simulateClampIsUNLOCKED(clamp);
        this.sentCurrentValue = 500;
        this.publishData();
        return String.valueOf(this.getName()) + " is turned ON.";
    }

    @Override
    public void writeCurrent(int currentValue) throws BadCommandException, SDORequestException {
        SimuFilterClampModule clamp;
        this.on = true;
        fcslog.debug((Object)(String.valueOf(this.getName()) + "==========> ACTUATOR ON"), new String[0]);
        if (this.name.contains("Xminus")) {
            clamp = (SimuFilterClampModule)this.carousel.getClampXminus();
        } else if (this.name.contains("Xplus")) {
            clamp = (SimuFilterClampModule)this.carousel.getClampXplus();
        } else {
            throw new BadCommandException(String.valueOf(this.name) + ":couldn't find the clamp to unlock");
        }
        ((SimuClampLockSensor)clamp.getLockSensor()).simulateClampIsUNLOCKED(clamp);
        this.sentCurrentValue = currentValue;
        this.publishData();
    }

    @Override
    public String off() throws BadCommandException, ErrorInCommandExecutionException {
        SimuFilterClampModule clamp;
        this.on = false;
        fcslog.debug((Object)(String.valueOf(this.getName()) + "==========> ACTUATOR OFF"), new String[0]);
        if (this.getName().contains("Xminus")) {
            clamp = (SimuFilterClampModule)this.carousel.getClampXminus();
        } else if (this.getName().contains("Xplus")) {
            clamp = (SimuFilterClampModule)this.carousel.getClampXplus();
        } else {
            throw new ErrorInCommandExecutionException(String.valueOf(this.getName()) + ": unable to find the clamp to unlock.");
        }
        ((SimuClampLockSensor)clamp.getLockSensor()).simulateClampIsLOCKED(clamp);
        this.sentCurrentValue = 0;
        this.publishData();
        return String.valueOf(this.getName()) + " is turned OFF.";
    }

    @Override
    public int getSentCurrentValue() {
        if (this.sentCurrentMinValue >= 0) {
            if (this.sentCurrentMaxValue > 0) {
                return this.r.nextInt(this.sentCurrentMaxValue);
            }
            String msg = String.valueOf(this.getName()) + ": ERROR in getSentValue: getSentCurrentMaxValue() should be positive";
            throw new IllegalArgumentException(msg);
        }
        return (int)this.r.nextGaussian() * this.sentCurrentMaxValue / 2;
    }

    public void tick() {
    }

    public String maintainUnclamped() throws BadCommandException, ErrorInCommandExecutionException {
        return String.valueOf(this.getName()) + "Maintaining Current";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        if (this.isOn()) {
            sb.append(" is ON");
        } else {
            sb.append(" is OFF");
        }
        return sb.toString();
    }

    public StatusDataPublishedByClampActuator getStatusData() {
        return FcsUtils.createStatusDataPublishedByClampActuator(this);
    }

    @Deprecated
    public void publishActuatorData() {
        KVList kvlist = new KVList(7);
        long timestamp = System.currentTimeMillis();
        kvlist.add("dataType", (Object)"carouselClampActuator");
        kvlist.add(String.valueOf(this.getName()) + "/sentValue", (Object)this.sentCurrentValue);
        this.publish(timestamp, kvlist);
    }

    public void publishData() {
        StatusDataPublishedByClampActuator status = this.getStatusData();
        this.publish("actuator", status);
    }

    @Override
    public void setOn(boolean on) {
        this.on = on;
    }

    @Override
    public String changeMode(EPOSEnumerations.EposMode newMode) throws SDORequestException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean checkMotorParameters() throws EPOSConfigurationException, SDORequestException, ShortResponseToSDORequestException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void defineAbsolutePosition(int position) throws SDORequestException, ErrorInCommandExecutionException, BadCommandException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeParameters(EPOSEnumerations.EposMode mode) throws SDORequestException, ErrorInCommandExecutionException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeTargetPosition(int aValue) throws BadCommandException, SDORequestException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void writeParameters(Map<String, Integer> paramMap) throws SDORequestException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isTargetPositionReached(int position) throws SDORequestException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int readPosition() throws SDORequestException, ShortResponseToSDORequestException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int readSSIPosition() throws SDORequestException, ShortResponseToSDORequestException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int readCurrent() throws BadCommandException, SDORequestException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String enable() throws SDORequestException {
        this.enabled = true;
        return String.valueOf(this.name) + " is ENABLED";
    }

    @Override
    public EPOSEnumerations.EposMode readMode() throws SDORequestException {
        return this.mode;
    }

    @Override
    public int getMinCurrent() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMaxCurrent() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMaxSpeed() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMaxPosition() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMinPosition() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void quickStop() throws SDORequestException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int readNumberOfErrors() throws SDORequestException, ShortResponseToSDORequestException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String displayErrorHistory() throws SDORequestException, ShortResponseToSDORequestException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void checkFault() throws SDORequestException, ShortResponseToSDORequestException, FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int readProfileVelocity() throws SDORequestException, ShortResponseToSDORequestException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String readParameters(EPOSEnumerations.EposMode mode) throws SDORequestException, ShortResponseToSDORequestException {
        return null;
    }

    @Override
    public void checkParameters(String modeInString) throws HardwareException, SDORequestException, ShortResponseToSDORequestException {
    }

    @Override
    public void checkParameters(EPOSEnumerations.EposMode aMode) throws HardwareException, SDORequestException, ShortResponseToSDORequestException {
    }

    @Override
    public void writeControlWord(String f) throws SDORequestException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String shutdown() throws SDORequestException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isEnabled() throws SDORequestException {
        return this.enabled;
    }

    @Override
    public boolean checkTargetReached() throws SDORequestException, ShortResponseToSDORequestException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void releaseBrake() throws SDORequestException, ShortResponseToSDORequestException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void switchOnEnableOperation() throws SDORequestException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void activateBrake() throws SDORequestException, ShortResponseToSDORequestException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getSerialNB() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getNodeID() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isBooted() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBooted(boolean aBoolean) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isInitialized() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String initializeHardware() throws FcsHardwareException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Map<String, Integer> getParamsForCurrent() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Map<String, Integer> getParamsForHoming() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Map<String, Integer> getParamsForProfilePosition() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isEnabledToPublish() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isInError() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getErrorRegister() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String[] getErrorHistory() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getModeInString() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String writeParameterInHexa(EPOSEnumerations.Parameter parameter, String string) throws SDORequestException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

