/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.LinkedHashMap;
import java.util.Map;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.drivers.BridgeToCanOpenHardware;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuCanOpenProxy;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSControllerModule;
import org.lsst.ccs.subsystems.fcs.simulation.SimuPlutoGateway;

public class SimuBridgeForLPSCTestBench
extends BridgeToCanOpenHardware {
    protected SimuCanOpenProxy tcpProxy;
    public SimuEPOSControllerModule hooksController;
    public SimuEPOSControllerModule carrierController;
    public SimuPlutoGateway plutoGateway;

    public SimuBridgeForLPSCTestBench(String name, int aTickMillis, SimuCanOpenProxy tcpProxy, SimuEPOSControllerModule hooksController, SimuEPOSControllerModule carrierController, SimuPlutoGateway plutoGateway) {
        super(name, aTickMillis, tcpProxy);
        this.tcpProxy = tcpProxy;
        this.hooksController = hooksController;
        this.carrierController = carrierController;
        this.plutoGateway = plutoGateway;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1, description="print my children; for tests")
    public void printChildren() {
        LinkedHashMap children = this.getChildren(SimuEPOSControllerModule.class);
        for (Map.Entry entry : children.entrySet()) {
            String key = (String)entry.getKey();
            fcslog.debug((Object)("key=" + key), new String[0]);
            SimuEPOSControllerModule epos = (SimuEPOSControllerModule)entry.getValue();
            fcslog.debug((Object)("epos=" + epos.getName() + "#" + epos.toString()), new String[0]);
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="print my children; for tests")
    public void printChildren2() {
        LinkedHashMap children = this.getChildren(EPOSController.class);
        for (Map.Entry entry : children.entrySet()) {
            String key = (String)entry.getKey();
            fcslog.debug((Object)("key=" + key), new String[0]);
            EPOSController epos = (EPOSController)entry.getValue();
            fcslog.debug((Object)("epos=" + epos.getName() + "#" + epos.toString()), new String[0]);
        }
    }

    @Override
    public boolean isCWrapperConnected() {
        return true;
    }

    @Override
    public boolean isHardwareReady() {
        return true;
    }

    @Override
    public boolean isRealHardware() {
        return false;
    }

    @Override
    public CanOpenProxy getTcpProxy() {
        return this.tcpProxy;
    }

    @Override
    public CanOpenProxy.PDOStorage readPDOs() throws FcsHardwareException, BadCommandException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void startServer() {
        this.tcpProxy.startServer();
    }

    @Override
    public void startThreadReader() {
        this.tcpProxy.startThreadReader();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/hooksController=");
        sb.append(String.valueOf(this.hooksController));
        sb.append("/carrierController=");
        sb.append(String.valueOf(this.carrierController));
        sb.append("/plutoGateway=");
        sb.append(String.valueOf(this.plutoGateway));
        return sb.toString();
    }
}

