/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.AutoChangerTrucksModule;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerLinearRailController;
import org.lsst.ccs.subsystems.fcs.simulation.SimuPlutoGWSensor;
import org.lsst.ccs.subsystems.fcs.simulation.SimuPlutoGateway;

public class SimuAutochangerPlutoGateway
extends SimuPlutoGateway {
    private AutoChangerTrucksModule trucks;
    SimuAutochangerLinearRailController trucksController;
    SimuPlutoGWSensor handoffPositionSensor0;
    SimuPlutoGWSensor handoffPositionSensor1;
    SimuPlutoGWSensor onlinePositionSensor0;
    SimuPlutoGWSensor onlinePositionSensor1;
    SimuPlutoGWSensor standbyPositionSensor0;
    SimuPlutoGWSensor standbyPositionSensor1;
    SimuPlutoGWSensor loaderConnectedSensor0;
    SimuPlutoGWSensor loaderConnectedSensor1;

    public SimuAutochangerPlutoGateway(String name, int tickMillis, String nodeID, String serialNB) {
        super(name, tickMillis, nodeID, serialNB);
    }

    @Override
    public void initModule() {
        super.initModule();
        this.hexaValues[0] = "00";
        this.hexaValues[1] = "00";
        this.hexaValues[2] = "00";
        this.hexaValues[3] = "00";
        this.hexaValues[4] = "00";
        this.hexaValues[5] = "00";
        this.handoffPositionSensor0 = (SimuPlutoGWSensor)this.getModule("handoffPositionSensor0");
        this.handoffPositionSensor1 = (SimuPlutoGWSensor)this.getModule("handoffPositionSensor1");
        this.onlinePositionSensor0 = (SimuPlutoGWSensor)this.getModule("onlinePositionSensor0");
        this.onlinePositionSensor1 = (SimuPlutoGWSensor)this.getModule("onlinePositionSensor1");
        this.standbyPositionSensor0 = (SimuPlutoGWSensor)this.getModule("standbyPositionSensor0");
        this.standbyPositionSensor1 = (SimuPlutoGWSensor)this.getModule("standbyPositionSensor1");
        this.loaderConnectedSensor0 = (SimuPlutoGWSensor)this.getModule("loaderConnectedSensor0");
        this.loaderConnectedSensor1 = (SimuPlutoGWSensor)this.getModule("loaderConnectedSensor1");
        this.trucksController = (SimuAutochangerLinearRailController)this.getModule("linearRailMasterController");
        this.trucks = (AutoChangerTrucksModule)this.getModule("trucks");
        this.simulateAutochangerTrucksIsOnline();
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerTrucksIsAtHandoff() {
        this.replaceDigitalValues(this.standbyPositionSensor0, "0");
        this.replaceDigitalValues(this.standbyPositionSensor1, "0");
        this.replaceDigitalValues(this.handoffPositionSensor0, "1");
        this.replaceDigitalValues(this.handoffPositionSensor1, "1");
        this.replaceDigitalValues(this.onlinePositionSensor0, "0");
        this.replaceDigitalValues(this.onlinePositionSensor1, "0");
        this.trucksController.setPosition(this.trucks.getHandoffPosition());
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerTrucksIsOnline() {
        this.replaceDigitalValues(this.standbyPositionSensor0, "0");
        this.replaceDigitalValues(this.standbyPositionSensor1, "0");
        this.replaceDigitalValues(this.handoffPositionSensor0, "0");
        this.replaceDigitalValues(this.handoffPositionSensor1, "0");
        this.replaceDigitalValues(this.onlinePositionSensor0, "1");
        this.replaceDigitalValues(this.onlinePositionSensor1, "1");
        this.trucksController.setPosition(this.trucks.getOnlinePosition());
        this.trucksController.setSsiPosition(this.trucks.getEncoderRibbonMinValue() + this.trucks.getOnlinePosition());
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerTrucksIsAtStandby() {
        this.replaceDigitalValues(this.standbyPositionSensor0, "1");
        this.replaceDigitalValues(this.standbyPositionSensor1, "1");
        this.replaceDigitalValues(this.handoffPositionSensor0, "0");
        this.replaceDigitalValues(this.handoffPositionSensor1, "0");
        this.replaceDigitalValues(this.onlinePositionSensor0, "0");
        this.replaceDigitalValues(this.onlinePositionSensor1, "0");
        this.trucksController.setPosition(this.trucks.getStandbyPosition());
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateAutochangerTrucksIsInTravel() {
        this.replaceDigitalValues(this.standbyPositionSensor0, "0");
        this.replaceDigitalValues(this.standbyPositionSensor1, "0");
        this.replaceDigitalValues(this.handoffPositionSensor0, "0");
        this.replaceDigitalValues(this.handoffPositionSensor1, "0");
        this.replaceDigitalValues(this.onlinePositionSensor0, "0");
        this.replaceDigitalValues(this.onlinePositionSensor1, "0");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderIsConnected() {
        this.replaceDigitalValues(this.loaderConnectedSensor0, "1");
        this.replaceDigitalValues(this.loaderConnectedSensor1, "1");
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public void simulateLoaderIsDisconnected() {
        this.replaceDigitalValues(this.loaderConnectedSensor0, "0");
        this.replaceDigitalValues(this.loaderConnectedSensor1, "0");
    }
}

