/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.simulation;

import java.util.Map;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.subsystems.fcs.AutoChangerTrucksModule;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.errors.SDORequestException;
import org.lsst.ccs.subsystems.fcs.simulation.SimuAutochangerPlutoGateway;
import org.lsst.ccs.subsystems.fcs.simulation.SimuEPOSControllerModule;

public class SimuAutochangerLinearRailController
extends SimuEPOSControllerModule {
    AutoChangerTrucksModule trucks;
    SimuAutochangerPlutoGateway plutoGateway;

    public SimuAutochangerLinearRailController(String aName, int aTickMillis, String nodeID, String serialNB, Map<String, Integer> paramsForCurrent, Map<String, Integer> paramsForProfilePosition, Map<String, Integer> paramsForHoming) {
        super(aName, aTickMillis, nodeID, serialNB, paramsForCurrent, paramsForProfilePosition, paramsForHoming);
    }

    public void setSsiPosition(int ssiPosition) {
        this.ssiPosition = ssiPosition;
    }

    @Override
    public void initModule() {
        this.trucks = (AutoChangerTrucksModule)this.getModule("autochangerTrucks");
        this.plutoGateway = (SimuAutochangerPlutoGateway)this.getModule("plutoGateway");
    }

    @Override
    public void writeTargetPosition(int positionToReached) throws BadCommandException, SDORequestException {
        this.targetPosition = positionToReached;
        int positionInitiale = this.position;
        fcslog.debug((Object)"loader trucks is moving.", new String[0]);
        fcslog.debug((Object)(String.valueOf(this.name) + "=>position intitiale=" + this.position), new String[0]);
        int stepsNB = Math.abs(this.targetPosition - this.position) > 10000 ? 20 : 5;
        int step = (this.targetPosition - this.position) / stepsNB;
        int i = 1;
        while (i < stepsNB) {
            try {
                this.position = positionInitiale + i * step;
                this.trucks.updatePosition();
                if (this.position == this.trucks.getHandoffPosition()) {
                    log.debug((Object)("plutoGateway=" + this.plutoGateway.toString()), new String[0]);
                    this.plutoGateway.simulateAutochangerTrucksIsAtHandoff();
                } else if (this.position == this.trucks.getStandbyPosition()) {
                    this.plutoGateway.simulateAutochangerTrucksIsAtStandby();
                } else if (this.position == this.trucks.getOnlinePosition()) {
                    this.plutoGateway.simulateAutochangerTrucksIsOnline();
                } else {
                    this.plutoGateway.simulateAutochangerTrucksIsInTravel();
                }
                this.trucks.updateStateWithSensors();
                this.trucks.publishData();
                fcslog.debug((Object)(String.valueOf(this.name) + "i=" + i + ",position=" + this.position), new String[0]);
                try {
                    Thread.sleep(500L);
                    if (this.trucks.getHaltRequired().get()) {
                        log.debug((Object)(String.valueOf(this.name) + " STOP simulated trucks motion."), new String[0]);
                        return;
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new BadCommandException(String.valueOf(this.name) + " sleep was interrupted.");
                }
            }
            catch (FcsHardwareException ex) {
                throw new BadCommandException(ex.getMessage());
            }
            ++i;
        }
        this.position = this.targetPosition;
        if (this.position == this.trucks.getHandoffPosition()) {
            log.debug((Object)("plutoGateway=" + this.plutoGateway.toString()), new String[0]);
            this.plutoGateway.simulateAutochangerTrucksIsAtHandoff();
        } else if (this.position == this.trucks.getStandbyPosition()) {
            this.plutoGateway.simulateAutochangerTrucksIsAtStandby();
        } else if (this.position == this.trucks.getOnlinePosition()) {
            this.plutoGateway.simulateAutochangerTrucksIsOnline();
        } else {
            this.plutoGateway.simulateAutochangerTrucksIsInTravel();
        }
    }
}

