/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.drivers;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.subsystems.fcs.NumericSensor;

public class CanOpenNumericSensor
extends NumericSensor {
    String dioName;
    int inputNumero;
    int byteNumero;

    public CanOpenNumericSensor(String aName, String dioName, int inputNumero) {
        super(aName);
        this.dioName = dioName;
        this.inputNumero = inputNumero;
    }

    public CanOpenNumericSensor(String aName, String dioName, int inputNumero, int byteNumero) {
        super(aName);
        this.dioName = dioName;
        this.inputNumero = inputNumero;
        this.byteNumero = byteNumero;
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public int getByteNumero() {
        return this.byteNumero;
    }

    @ConfigChanger
    public void setByteNumero(int byteNumero) {
        this.byteNumero = byteNumero;
    }

    @Command(type=Command.CommandType.QUERY, level=1)
    public int getInputNumero() {
        return this.inputNumero;
    }

    @ConfigChanger
    public void setInputNumero(int inputNumero) {
        this.inputNumero = inputNumero;
    }

    @Override
    public synchronized void updateValue(String hex) {
        fcslog.finest((Object)(String.valueOf(this.name) + " INPUT NO=" + this.inputNumero), new String[0]);
        String bin = Integer.toBinaryString(Integer.parseInt(hex, 16));
        String s = String.format("%08d", Integer.parseInt(bin));
        fcslog.finest((Object)(String.valueOf(this.name) + " binary value=" + s), new String[0]);
        int myValue = Character.digit(s.charAt(7 - this.inputNumero), 16);
        fcslog.finest((Object)(String.valueOf(this.name) + " Value updated=" + myValue), new String[0]);
        this.digitalValue = myValue;
    }

    @Override
    public synchronized void updateValue(String[] hexaValues) {
        this.updateValue(hexaValues[this.byteNumero]);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, level=1)
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("/DIO module=");
        sb.append(this.dioName);
        sb.append("/Input numero=");
        sb.append(String.valueOf(this.inputNumero));
        sb.append("/byteNumero=");
        sb.append(String.valueOf(this.byteNumero));
        sb.append("/digitalValue=");
        sb.append(String.valueOf(this.digitalValue));
        return sb.toString();
    }
}

