/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.SignalLevel;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;
import org.lsst.ccs.utilities.logging.Logger;

public abstract class MobileItemModule
extends Module
implements HardwareController {
    protected static final Logger fcslog = FcsUtils.log;
    protected volatile boolean hasToWaitForEndOfAction = false;
    protected volatile FcsEnumerations.MobileItemAction currentAction;
    protected volatile boolean moving = false;
    protected final Lock lock = new ReentrantLock();
    protected final Condition motionCompleted = this.lock.newCondition();
    ScheduledFuture<?> readSensorsHandle;
    final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1);
    protected AtomicBoolean haltRequired = new AtomicBoolean();
    protected AtomicBoolean stopRequired;

    public MobileItemModule(String moduleName, int aTickMillis) {
        super(moduleName, aTickMillis);
        this.haltRequired.set(false);
        this.stopRequired = new AtomicBoolean();
        this.stopRequired.set(false);
    }

    public boolean isMoving() {
        return this.moving;
    }

    public AtomicBoolean getHaltRequired() {
        return this.haltRequired;
    }

    private void cancelReadingSensors() {
        this.lock.lock();
        try {
            fcslog.debug((Object)(String.valueOf(this.getName()) + " => stop reading sensors"), new String[0]);
            this.motionCompleted.signal();
        }
        finally {
            this.lock.unlock();
        }
        this.readSensorsHandle.cancel(true);
        fcslog.debug((Object)(String.valueOf(this.getName()) + " => readingSensors canceled"), new String[0]);
    }

    public abstract boolean isHardwareReady();

    public abstract boolean isActionCompleted(FcsEnumerations.MobileItemAction var1);

    public abstract void updateStateWithSensorsToCheckIfActionIsCompleted() throws Exception;

    public abstract void startAction(FcsEnumerations.MobileItemAction var1) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException;

    public abstract void abortAction(FcsEnumerations.MobileItemAction var1, long var2) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException;

    public abstract void quickStopAction(FcsEnumerations.MobileItemAction var1, long var2) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException;

    public abstract void postAction(FcsEnumerations.MobileItemAction var1) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException;

    public abstract void publishData();

    protected String executeAction(FcsEnumerations.MobileItemAction action, long timeoutForAction) throws BadCommandException, ErrorInCommandExecutionException, FcsHardwareException {
        if (!this.isHardwareReady()) {
            throw new FcsHardwareException(String.valueOf(this.name) + ": hardware is not ready to execute ACTION commands.");
        }
        this.lock.lock();
        try {
            this.hasToWaitForEndOfAction = true;
            this.currentAction = action;
            this.moving = true;
            fcslog.debug((Object)this.name, new String[]{"STARTING ACTION:" + action.toString()});
            this.startAction(action);
            this.readSensorsUntilActionIsCompleted(action, System.currentTimeMillis(), timeoutForAction);
            this.waitForEndOfAction(action);
            if (this.haltRequired.get()) {
                this.abortAction(action, 0L);
                this.moving = false;
                String string = String.valueOf(this.name) + "=> Received an ABORT command for action :" + action.toString();
                return string;
            }
            if (this.stopRequired.get()) {
                this.quickStopAction(action, 0L);
                this.moving = false;
                String string = String.valueOf(this.name) + "=> Received a STOP command for action :" + action.toString();
                return string;
            }
            if (this.isActionCompleted(action)) {
                this.moving = false;
                this.postAction(action);
                String string = String.valueOf(this.name) + " " + action.doneString();
                return string;
            }
            throw new ErrorInCommandExecutionException(String.valueOf(this.name) + "=>" + action.getFailureMsg());
        }
        finally {
            fcslog.debug((Object)(String.valueOf(this.name) + ": finally in executeAction."), new String[0]);
            this.abortAction(action, 0L);
            this.moving = false;
            this.hasToWaitForEndOfAction = false;
            this.motionCompleted.signal();
            this.haltRequired.set(false);
            this.stopRequired.set(false);
            this.lock.unlock();
            this.publishData();
        }
    }

    public void readSensorsUntilActionIsCompleted(final FcsEnumerations.MobileItemAction action, final long beginTime, final long timeout) {
        Runnable readSensors = new Runnable(){

            @Override
            public void run() {
                try {
                    fcslog.info((Object)(String.valueOf(MobileItemModule.this.name) + " : reading sensors"), new String[0]);
                    long duration = System.currentTimeMillis() - beginTime;
                    MobileItemModule.this.updateStateWithSensorsToCheckIfActionIsCompleted();
                    boolean actionCompleted = MobileItemModule.this.isActionCompleted(action);
                    if (MobileItemModule.this.haltRequired.get() || MobileItemModule.this.stopRequired.get()) {
                        MobileItemModule.this.hasToWaitForEndOfAction = false;
                        fcslog.info((Object)(String.valueOf(action.toString()) + " ABORT or STOP REQUESTED FOR ACTION " + "BY ABORT or STOP COMMAND"), new String[0]);
                        MobileItemModule.this.cancelReadingSensors();
                    } else if (actionCompleted) {
                        MobileItemModule.this.hasToWaitForEndOfAction = false;
                        fcslog.info((Object)(String.valueOf(action.toString()) + " ACTION COMPLETED"), new String[0]);
                        MobileItemModule.this.cancelReadingSensors();
                    } else {
                        if (duration >= timeout) {
                            MobileItemModule.this.hasToWaitForEndOfAction = false;
                            fcslog.info((Object)(String.valueOf(action.toString()) + " ACTION NOT COMPLETED during allocated time"), new String[0]);
                            MobileItemModule.this.cancelReadingSensors();
                            throw new FcsHardwareException(String.valueOf(action.toString()) + " exceeded timeout for this task: duration=" + duration + ",timeout=" + timeout);
                        }
                        fcslog.info((Object)(String.valueOf(action.toString()) + " not completed....."), new String[0]);
                        fcslog.info((Object)(String.valueOf(action.name()) + "/duration=" + duration), new String[0]);
                    }
                }
                catch (Exception ex) {
                    MobileItemModule.this.hasToWaitForEndOfAction = false;
                    fcslog.error((Object)("ERROR during action:" + ex.getMessage()), new String[0]);
                    MobileItemModule.this.cancelReadingSensors();
                    MobileItemModule.this.getSubsystem().raiseAlarm(ex.toString());
                }
            }
        };
        this.readSensorsHandle = this.scheduler.scheduleAtFixedRate(readSensors, 500L, 500L, TimeUnit.MILLISECONDS);
    }

    private void waitForEndOfAction(FcsEnumerations.MobileItemAction action) {
        while (this.hasToWaitForEndOfAction) {
            try {
                fcslog.info((Object)(String.valueOf(this.name) + " waiting for end of " + action.toString()), new String[0]);
                this.motionCompleted.await();
            }
            catch (InterruptedException ex) {
                fcslog.info((Object)(String.valueOf(this.name) + ": InterruptedException received=" + ex.toString()), new String[0]);
                break;
            }
        }
        fcslog.info((Object)(String.valueOf(this.name) + " STOP WAITING FOR END OF ACTION"), new String[0]);
    }

    private void halt(FcsEnumerations.MobileItemAction action, long delay) {
        if (action == null) {
            fcslog.warning((Object)(String.valueOf(this.name) + ": no current action running => nothing to abort."), new String[0]);
            return;
        }
        try {
            fcslog.debug((Object)(String.valueOf(this.name) + ": ABORTING ACTION " + action.toString() + "within delay=" + delay), new String[0]);
            this.abortAction(action, delay);
            this.moving = false;
        }
        catch (BadCommandException | ErrorInCommandExecutionException | FcsHardwareException ex) {
            fcslog.error((Object)(String.valueOf(this.name) + " couldn't abort action " + action.toString()), new String[0]);
            this.getSubsystem().raiseAlarm(ex.toString());
        }
    }

    private void quickStop(FcsEnumerations.MobileItemAction action, long delay) {
        if (action == null) {
            fcslog.warning((Object)(String.valueOf(this.name) + ": no current action running => nothing to stop."), new String[0]);
            return;
        }
        try {
            fcslog.debug((Object)(String.valueOf(this.name) + ": QUICKSTOP for" + action.toString() + "within delay=" + delay), new String[0]);
            this.quickStopAction(action, delay);
            this.moving = false;
        }
        catch (BadCommandException | ErrorInCommandExecutionException | FcsHardwareException ex) {
            fcslog.error((Object)(String.valueOf(this.name) + " couldn't do stop action " + action.toString()), new String[0]);
            this.getSubsystem().raiseAlarm(ex.toString());
        }
    }

    @Command(type=Command.CommandType.ABORT, level=1, description="Abort the running action within a delay.")
    public void abort(long delay) throws BadCommandException {
        this.sendSignalWithTimeLimit("HALT", delay);
    }

    @Command(type=Command.CommandType.ABORT, level=1, description="Abort the running action.")
    public void abort() throws BadCommandException {
        this.abort(0L);
    }

    @Command(type=Command.CommandType.ABORT, level=1, description="Stop the running action with a quickstop.")
    public void stop(long delay) throws BadCommandException {
        this.sendSignalWithTimeLimit("STOP", delay);
    }

    @Command(type=Command.CommandType.ABORT, level=1, description="Stop the running action with a quickstop.")
    public void stop() throws BadCommandException {
        this.stop(0L);
    }

    @Command(type=Command.CommandType.ABORT, level=1, description="Stop the running action with a quickstop.")
    public void quickstop() throws BadCommandException {
        this.stop(0L);
    }

    public void shutdownNow() {
        super.shutdownNow();
        this.scheduler.shutdown();
    }

    public TreeWalkerDiag signal(Signal signal) {
        SignalLevel sl = signal.getLevel();
        fcslog.info((Object)sl.toString(), new String[0]);
        if (!this.moving) {
            fcslog.warning((Object)(String.valueOf(this.name) + " is not moving; nothing to stop."), new String[0]);
        } else {
            switch (signal.getLevel()) {
                case HALT: {
                    fcslog.info((Object)(String.valueOf(this.getName()) + " HALT required"), new String[0]);
                    this.haltRequired.set(true);
                    this.halt(this.currentAction, signal.getExpectedMaxDelay());
                    break;
                }
                case STOP: {
                    fcslog.info((Object)(String.valueOf(this.getName()) + " STOP required"), new String[0]);
                    this.stopRequired.set(true);
                    this.quickStop(this.currentAction, signal.getExpectedMaxDelay());
                    break;
                }
                case INTERRUPT1: {
                    break;
                }
                case INTERRUPT2: {
                    break;
                }
                case RE_START: {
                    this.haltRequired.set(false);
                }
            }
        }
        return TreeWalkerDiag.HANDLING_CHILDREN;
    }

    public TreeWalkerDiag checkHardware() throws HardwareException {
        return TreeWalkerDiag.GO;
    }

    public void checkStarted() throws HardwareException {
    }

    public void checkStopped() throws HardwareException {
        if (this.isMoving()) {
            throw new HardwareException(false, String.valueOf(this.name) + " is moving, has to be stopped before a shutdown.");
        }
    }
}

