/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.concurrent.atomic.AtomicBoolean;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.ErrorInCommandExecutionException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.state.PublishedState;
import org.lsst.ccs.subsystems.fcs.common.BridgeToHardware;
import org.lsst.ccs.subsystems.fcs.config.CanOpenProxyConfig;
import org.lsst.ccs.subsystems.fcs.drivers.CanOpenProxy;
import org.lsst.ccs.subsystems.fcs.errors.FcsHardwareException;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.tracers.Tracer;

public abstract class MainModule
extends Module {
    protected static final Logger fcslog = FcsUtils.log;
    protected BridgeToHardware bridge;
    protected boolean hardwareReady = false;
    protected AtomicBoolean haltRequired;
    protected AtomicBoolean stopRequired;

    static {
        assert (Tracer.version((String)"$Rev$", MainModule.class, (String)"org-lsst-ccs-subsystems-fcs"));
    }

    public MainModule(String aName, int aTickMillis, BridgeToHardware bridge) {
        super(aName, aTickMillis);
        this.bridge = bridge;
    }

    public AtomicBoolean getHaltRequired() {
        return this.haltRequired;
    }

    public AtomicBoolean getStopRequired() {
        return this.stopRequired;
    }

    public void initModule() {
        this.haltRequired = new AtomicBoolean(false);
        this.stopRequired = new AtomicBoolean(false);
        String msg = this.controlRealHardware() ? "Real Hardware" : "Simulation";
        fcslog.info((Object)(String.valueOf(this.name) + ":" + msg), new String[0]);
    }

    public void postStart() throws HardwareException {
        log.fine((Object)(String.valueOf(this.name) + ":postStart begins."), new String[0]);
        try {
            this.updateStateWithSensors();
        }
        catch (BadCommandException | ErrorInCommandExecutionException | FcsHardwareException ex) {
            throw new HardwareException(true, ex.getMessage());
        }
        log.fine((Object)(String.valueOf(this.name) + ":postStart ends."), new String[0]);
        this.startTicking();
    }

    @Command(level=1, description="Return true if hardware is booted, identified and initialized.", type=Command.CommandType.QUERY)
    public boolean isHardwareReady() {
        if (this.hardwareReady) {
            return this.hardwareReady;
        }
        this.hardwareReady = this.bridge.isHardwareReady();
        return this.hardwareReady;
    }

    @Command(type=Command.CommandType.QUERY, description="Return true if this main module controls real hardware.")
    public boolean controlRealHardware() {
        return this.bridge.isRealHardware();
    }

    @Command(level=1, description="Return the list of CANopen hardware that this subsystem manages.", type=Command.CommandType.QUERY)
    public String listHardware() {
        return this.bridge.getTcpProxy().listHardware();
    }

    public void updateStateWithSensors() throws FcsHardwareException, ErrorInCommandExecutionException, BadCommandException {
        this.getTcpProxy().publishData();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="The GUIs need that for the initialization.")
    public CanOpenProxyConfig getCanOpenHardwareFullState() {
        return FcsUtils.createCanOpenProxyConfig(this.bridge.getTcpProxy());
    }

    public CanOpenProxy getTcpProxy() {
        return this.bridge.getTcpProxy();
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the subsystem state.")
    public String getSubsystemState() {
        PublishedState subState = this.getSubsystem().getStateForPublication();
        log.debug((Object)subState.toString(), new String[0]);
        return subState.toString();
    }

    public TreeWalkerDiag signal(Signal signal) {
        switch (signal.getLevel()) {
            case HALT: {
                fcslog.debug((Object)"HALT required", new String[0]);
                this.haltRequired.set(true);
                break;
            }
            case STOP: {
                fcslog.debug((Object)"STOP required", new String[0]);
                this.stopRequired.set(true);
                break;
            }
            case INTERRUPT1: {
                break;
            }
            case INTERRUPT2: {
                break;
            }
            case RE_START: {
                this.haltRequired.set(false);
                this.stopRequired.set(false);
            }
        }
        return TreeWalkerDiag.GO;
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="For tests purpose - raise an alarm.")
    public void simulateAlarm(String alarmMsg) {
        log.debug((Object)(String.valueOf(this.name) + "An Alarm was raised:" + alarmMsg), new String[0]);
        this.getSubsystem().raiseAlarm(alarmMsg);
    }

    public String toString() {
        return super.toString();
    }
}

