/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.NumericSensor;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class LoaderHookModule
extends Module {
    protected static final Logger fcslog = FcsUtils.log;
    private final NumericSensor lockSensor;
    private final NumericSensor unlockSensor;
    FcsEnumerations.LockStatus lockStatus;
    protected final Lock lock = new ReentrantLock();
    final Condition stateUpdated = this.lock.newCondition();
    private boolean locked;
    private boolean unlocked;
    private boolean inError;
    private boolean inTravel;
    protected volatile boolean updatingState = false;

    public LoaderHookModule(String name, NumericSensor lockSensor, NumericSensor unlockSensor) {
        super(name);
        this.lockSensor = lockSensor;
        this.unlockSensor = unlockSensor;
    }

    public NumericSensor getLockSensor() {
        return this.lockSensor;
    }

    public NumericSensor getUnlockSensor() {
        return this.unlockSensor;
    }

    public boolean isInError() {
        return this.inError;
    }

    /*
     * Exception decompiling
     */
    public FcsEnumerations.LockStatus getLockStatus() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void initModule() {
        this.lockStatus = FcsEnumerations.LockStatus.UNKNOWN;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Update state in reading sensors.")
    public void updateStateWithSensors(String[] hexaValues) {
        this.lock.lock();
        try {
            this.updatingState = true;
            this.lockSensor.updateValue(hexaValues);
            this.unlockSensor.updateValue(hexaValues);
            this.locked = this.lockSensor.getDigitalValue() == 1;
            this.unlocked = this.unlockSensor.getDigitalValue() == 1;
            this.inTravel = !this.locked && !this.unlocked;
            boolean bl = this.inError = this.locked && this.unlocked;
            if (this.inError) {
                this.lockStatus = FcsEnumerations.LockStatus.ERROR;
            } else if (this.locked) {
                this.lockStatus = FcsEnumerations.LockStatus.LOCKED;
            } else if (this.unlocked) {
                this.lockStatus = FcsEnumerations.LockStatus.UNLOCKED;
            } else if (this.inTravel) {
                this.lockStatus = FcsEnumerations.LockStatus.INTRAVEL;
            }
        }
        finally {
            this.updatingState = false;
            this.stateUpdated.signal();
            this.lock.unlock();
        }
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="display sensors info")
    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("#locksensor=");
        sb.append(this.lockSensor.toString());
        sb.append("#unlocksensor=");
        sb.append(this.unlockSensor.toString());
        return sb.toString();
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="List and display hook sensors values.")
    public String listSensorsValues() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("/locksensor value=");
        sb.append(this.lockSensor.getDigitalValue());
        sb.append("/unlocksensor value=");
        sb.append(this.unlockSensor.getDigitalValue());
        sb.append("/lockStatus=");
        sb.append(this.lockStatus.toString());
        sb.append("/");
        return sb.toString();
    }
}

